/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.relay;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.relay.RelaySessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public class RelayOptions {
    static final String RELAY_SECTION = "relay";
    private static final Logger LOG = Logger.getLogger(RelayOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public RelayOptions(Config config) {
        this.config = Require.nonNull("Config", config);
    }

    private URI getServiceUri() {
        try {
            Optional<String> possibleUri = this.config.get(RELAY_SECTION, "url");
            if (possibleUri.isPresent()) {
                return new URI(possibleUri.get());
            }
            Optional<String> possibleHost = this.config.get(RELAY_SECTION, "host");
            Optional<Integer> possiblePort = this.config.getInt(RELAY_SECTION, "port");
            if (possibleHost.isPresent() && possiblePort.isPresent()) {
                String host = possibleHost.get();
                int port = possiblePort.get();
                host = !host.startsWith("http") ? String.format("http://%s:%s", host, port) : String.format("%s:%s", host, port);
                URI uri = new URI(host);
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            throw new ConfigException("Unable to determine the service url", new Object[0]);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to determine the service url", new Object[]{e});
        }
    }

    private boolean isServerUp(HttpClient client) {
        if (!this.config.get(RELAY_SECTION, "status-endpoint").isPresent()) {
            return true;
        }
        String statusEndpoint = this.config.get(RELAY_SECTION, "status-endpoint").orElse("/status");
        if (!statusEndpoint.startsWith("/")) {
            statusEndpoint = "/" + statusEndpoint;
        }
        try {
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, statusEndpoint));
            LOG.fine(Contents.string(response));
            return 200 == response.getStatus();
        }
        catch (Exception e) {
            throw new ConfigException("Unable to reach the service at " + this.getServiceUri(), new Object[]{e});
        }
    }

    public Map<Capabilities, Collection<SessionFactory>> getSessionFactories(Tracer tracer, HttpClient.Factory clientFactory) {
        HttpClient client = clientFactory.createClient(ClientConfig.defaultConfig().baseUri(this.getServiceUri()));
        if (!this.isServerUp(client)) {
            throw new ConfigException("Unable to reach the service at " + this.getServiceUri(), new Object[0]);
        }
        List<String> allConfigs = this.config.getAll(RELAY_SECTION, "configs").orElseThrow(() -> new ConfigException("Unable to find configs for " + this.getServiceUri(), new Object[0]));
        HashMultimap<Integer, Capabilities> parsedConfigs = HashMultimap.create();
        for (int i = 0; i < allConfigs.size(); ++i) {
            int maxSessions2;
            try {
                maxSessions2 = Integer.parseInt(this.extractConfiguredValue(allConfigs.get(i)));
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Unable parse value as number. " + allConfigs.get(i), new Object[0]);
            }
            if (++i == allConfigs.size()) {
                throw new ConfigException("Unable to find stereotype config. " + allConfigs, new Object[0]);
            }
            Capabilities stereotype2 = (Capabilities)JSON.toType(this.extractConfiguredValue(allConfigs.get(i)), (Type)((Object)Capabilities.class));
            parsedConfigs.put(maxSessions2, stereotype2);
        }
        ImmutableMultimap.Builder factories = ImmutableMultimap.builder();
        LOG.info(String.format("Adding relay configs for %s", this.getServiceUri()));
        parsedConfigs.forEach((maxSessions, stereotype) -> {
            for (int i = 0; i < maxSessions; ++i) {
                factories.put(stereotype, new RelaySessionFactory(tracer, clientFactory, this.getServiceUri(), (Capabilities)stereotype));
            }
            LOG.info(String.format("Mapping %s, %d times", stereotype, maxSessions));
        });
        return factories.build().asMap();
    }

    private String extractConfiguredValue(String keyValue) {
        if (keyValue.contains("=")) {
            return keyValue.substring(keyValue.indexOf("=") + 1);
        }
        return keyValue;
    }
}

