/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.net.URL;
import java.time.Instant;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.node.BaseActiveSession;
import org.openqa.selenium.grid.web.ProtocolConverter;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public abstract class ProtocolConvertingSession
extends BaseActiveSession {
    private final HttpHandler handler;
    private final String killUrl;

    protected ProtocolConvertingSession(Tracer tracer, HttpClient client, SessionId id, URL url, Dialect downstream, Dialect upstream, Capabilities stereotype, Capabilities capabilities, Instant startTime) {
        super(id, url, downstream, upstream, stereotype, capabilities, startTime);
        Require.nonNull("HTTP client", client);
        this.handler = downstream.equals((Object)upstream) ? new ReverseProxyHandler(tracer, client) : new ProtocolConverter(tracer, client, downstream, upstream);
        this.killUrl = "/session/" + id;
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        String host = "host";
        StreamSupport.stream(req.getHeaderNames().spliterator(), true).filter(host::equalsIgnoreCase).collect(Collectors.toList()).forEach(x$0 -> {
            HttpRequest cfr_ignored_0 = (HttpRequest)req.removeHeader((String)x$0);
        });
        req.addHeader(host, String.format("%s:%s", this.getUri().getHost(), this.getUri().getPort()));
        HttpResponse res = this.handler.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && this.killUrl.equals(req.getUri())) {
            this.stop();
        }
        return res;
    }
}

