/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;

public class DistributorOptions {
    public static final int DEFAULT_HEALTHCHECK_INTERVAL = 120;
    public static final String DISTRIBUTOR_SECTION = "distributor";
    static final String DEFAULT_DISTRIBUTOR_IMPLEMENTATION = "org.openqa.selenium.grid.distributor.local.LocalDistributor";
    static final String DEFAULT_SLOT_MATCHER = "org.openqa.selenium.grid.data.DefaultSlotMatcher";
    static final String DEFAULT_SLOT_SELECTOR_IMPLEMENTATION = "org.openqa.selenium.grid.distributor.selector.DefaultSlotSelector";
    static final String DEFAULT_GRID_MODEL_IMPLEMENTATION = "org.openqa.selenium.grid.distributor.GridModel";
    static final boolean DEFAULT_REJECT_UNSUPPORTED_CAPS = false;
    private final Config config;

    public DistributorOptions(Config config) {
        this.config = config;
    }

    public URI getDistributorUri() {
        Optional<URI> host = this.config.get(DISTRIBUTOR_SECTION, "host").map(str -> {
            try {
                URI distributorUri = new URI((String)str);
                if (distributorUri.getHost() == null || distributorUri.getPort() == -1) {
                    throw new ConfigException("Undefined host or port in Distributor server URI: " + str, new Object[0]);
                }
                return distributorUri;
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Distributor URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt(DISTRIBUTOR_SECTION, "port");
        Optional<String> hostname = this.config.get(DISTRIBUTOR_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the distributor", new Object[0]);
        }
        try {
            return new URI("http", null, hostname.get(), port.get(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Distributor uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }

    public Duration getHealthCheckInterval() {
        int seconds = Math.max(this.config.getInt(DISTRIBUTOR_SECTION, "healthcheck-interval").orElse(120), 10);
        return Duration.ofSeconds(seconds);
    }

    public Distributor getDistributor() {
        return this.config.getClass(DISTRIBUTOR_SECTION, "implementation", Distributor.class, DEFAULT_DISTRIBUTOR_IMPLEMENTATION);
    }

    public SlotMatcher getSlotMatcher() {
        return this.config.getClass(DISTRIBUTOR_SECTION, "slot-matcher", SlotMatcher.class, DEFAULT_SLOT_MATCHER);
    }

    public SlotSelector getSlotSelector() {
        return this.config.getClass(DISTRIBUTOR_SECTION, "slot-selector", SlotSelector.class, DEFAULT_SLOT_SELECTOR_IMPLEMENTATION);
    }

    public boolean shouldRejectUnsupportedCaps() {
        return this.config.getBool(DISTRIBUTOR_SECTION, "reject-unsupported-caps").orElse(false);
    }
}

