/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.Internal;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;

@Internal
public class GraphqlFloatCoercing
implements Coercing<Double, Double> {
    private Double convertImpl(Object input) {
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            return value.doubleValue();
        }
        return null;
    }

    @Override
    public Double serialize(Object input) {
        Double result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Expected type 'Float' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Double parseValue(Object input) {
        Double result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Expected type 'Float' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Double parseLiteral(Object input) {
        if (input instanceof IntValue) {
            return ((IntValue)input).getValue().doubleValue();
        }
        if (input instanceof FloatValue) {
            return ((FloatValue)input).getValue().doubleValue();
        }
        throw new CoercingParseLiteralException("Expected AST type 'IntValue' or 'FloatValue' but was '" + CoercingUtil.typeName(input) + "'.");
    }

    @Override
    public Value valueToLiteral(Object input) {
        Double result = Assert.assertNotNull(this.convertImpl(input));
        return FloatValue.newFloatValue(BigDecimal.valueOf(result)).build();
    }
}

