/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.relay;

import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.ProtocolConvertingSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class RelaySessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(RelaySessionFactory.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final URL serviceUrl;
    private final Capabilities stereotype;

    public RelaySessionFactory(Tracer tracer, HttpClient.Factory clientFactory, URI serviceUri, Capabilities stereotype) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.clientFactory = Require.nonNull("HTTP client", clientFactory);
        this.serviceUrl = this.createServiceUrl(Require.nonNull("Service URL", serviceUri));
        this.stereotype = ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype));
    }

    @Override
    public boolean test(Capabilities capabilities) {
        boolean platformVersionMatch = capabilities.getCapabilityNames().stream().filter(name -> name.contains("platformVersion")).map(platformVersionCapName -> Objects.equals(this.stereotype.getCapability((String)platformVersionCapName), capabilities.getCapability((String)platformVersionCapName))).reduce(Boolean::logicalAnd).orElse(true);
        return platformVersionMatch && this.stereotype.getCapabilityNames().stream().filter(name -> capabilities.asMap().containsKey(name)).map(name -> {
            if (capabilities.getCapability((String)name) instanceof String) {
                return this.stereotype.getCapability((String)name).toString().equalsIgnoreCase(capabilities.getCapability((String)name).toString());
            }
            return capabilities.getCapability((String)name) == null || Objects.equals(this.stereotype.getCapability((String)name), capabilities.getCapability((String)name));
        }).reduce(Boolean::logicalAnd).orElse(false) != false;
    }

    @Override
    public Either<WebDriverException, ActiveSession> apply(CreateSessionRequest sessionRequest) {
        Capabilities capabilities = sessionRequest.getDesiredCapabilities();
        if (!this.test(capabilities)) {
            return Either.left(new SessionNotCreatedException("New session request capabilities do not match the stereotype."));
        }
        LOG.info("Starting session for " + capabilities);
        Span span = this.tracer.getCurrentContext().createSpan("relay_session_factory.apply");
        HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
        RemoteTags.CAPABILITIES.accept(span, capabilities);
        RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, capabilities);
        attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue(this.getClass().getName()));
        attributeMap.put(AttributeKey.DRIVER_URL.getKey(), EventAttribute.setValue(this.serviceUrl.toString()));
        HttpClient client = this.clientFactory.createClient(this.serviceUrl);
        Command command = new Command(null, DriverCommand.NEW_SESSION(capabilities));
        try {
            ProtocolHandshake.Result result = new ProtocolHandshake().createSession((HttpHandler)client, command);
            Set<Dialect> downstreamDialects = sessionRequest.getDownstreamDialects();
            Dialect upstream = result.getDialect();
            Dialect downstream = downstreamDialects.contains((Object)result.getDialect()) ? result.getDialect() : downstreamDialects.iterator().next();
            Response response = result.createResponse();
            attributeMap.put(AttributeKey.UPSTREAM_DIALECT.getKey(), EventAttribute.setValue(upstream.toString()));
            attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), EventAttribute.setValue(downstream.toString()));
            attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue(response.toString()));
            ImmutableCapabilities responseCaps = new ImmutableCapabilities((Map)response.getValue());
            Capabilities mergedCapabilities = capabilities.merge(responseCaps);
            span.addEvent("Relay service created session", attributeMap);
            LOG.fine(String.format("Created session: %s - %s", response.getSessionId(), capabilities));
            Either<WebDriverException, ActiveSession> either = Either.right(new ProtocolConvertingSession(this.tracer, client, new SessionId(response.getSessionId()), this.serviceUrl, downstream, upstream, this.stereotype, mergedCapabilities, Instant.now()){

                @Override
                public void stop() {
                }
            });
            if (span != null) {
                span.close();
            }
            return either;
        }
        catch (Exception e) {
            try {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                String errorMessage = String.format("Error while creating session with the service %s. %s", this.serviceUrl, e.getMessage());
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue(errorMessage));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                Either<WebDriverException, ActiveSession> either = Either.left(new SessionNotCreatedException(errorMessage));
                if (span != null) {
                    span.close();
                }
                return either;
            }
            catch (Throwable throwable) {
                try {
                    if (span != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    return Either.left(new SessionNotCreatedException(e2.getMessage()));
                }
            }
        }
    }

    @VisibleForTesting
    URL getServiceUrl() {
        return this.serviceUrl;
    }

    private URL createServiceUrl(URI serviceUri) {
        try {
            return serviceUri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

