/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.io.UncheckedIOException;
import java.util.UUID;
import java.util.function.Predicate;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.distributor.AddNode;
import org.openqa.selenium.grid.distributor.CreateSession;
import org.openqa.selenium.grid.distributor.DrainNode;
import org.openqa.selenium.grid.distributor.GetDistributorStatus;
import org.openqa.selenium.grid.distributor.RemoveNode;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.RequiresSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class Distributor
implements HasReadyState,
Predicate<HttpRequest>,
Routable {
    private final Route routes;
    protected final Tracer tracer;

    protected Distributor(Tracer tracer, HttpClient.Factory httpClientFactory, Secret registrationSecret) {
        this.tracer = Require.nonNull("Tracer", tracer);
        Require.nonNull("HTTP client factory", httpClientFactory);
        Require.nonNull("Registration secret", registrationSecret);
        RequiresSecretFilter requiresSecret = new RequiresSecretFilter(registrationSecret);
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.post("/se/grid/distributor/node").to(() -> new AddNode(tracer, this, json, httpClientFactory, registrationSecret)).with(requiresSecret), new Routable[]{Route.post("/se/grid/distributor/node/{nodeId}/drain").to(params -> new DrainNode(this, new NodeId(UUID.fromString((String)params.get("nodeId"))))).with(requiresSecret), Route.delete("/se/grid/distributor/node/{nodeId}").to(params -> new RemoveNode(this, new NodeId(UUID.fromString((String)params.get("nodeId"))))).with(requiresSecret), Route.post("/se/grid/distributor/session").to(() -> new CreateSession(this)).with(requiresSecret), Route.get("/se/grid/distributor/status").to(() -> new GetDistributorStatus(this)).with(new SpanDecorator(tracer, req -> "distributor.status"))});
    }

    public abstract Either<SessionNotCreatedException, CreateSessionResponse> newSession(SessionRequest var1) throws SessionNotCreatedException;

    public abstract Distributor add(Node var1);

    public abstract boolean drain(NodeId var1);

    public abstract void remove(NodeId var1);

    public abstract DistributorStatus getStatus();

    @Override
    public boolean test(HttpRequest httpRequest) {
        return this.matches(httpRequest);
    }

    @Override
    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.routes.execute(req);
    }
}

