/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import io.ous.jtoml.JToml;
import io.ous.jtoml.ParseException;
import io.ous.jtoml.Toml;
import io.ous.jtoml.TomlTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.internal.Require;

public class TomlConfig
implements Config {
    private final Toml toml;

    public TomlConfig(Reader reader) {
        try {
            this.toml = JToml.parse(reader);
        }
        catch (IOException e) {
            throw new ConfigException("Unable to read TOML.", new Object[]{e});
        }
        catch (ParseException e) {
            throw new ConfigException(e.getCause() + "\n Validate the config using https://www.toml-lint.com/. \n Refer to https://toml.io/en/ for TOML usage guidance. ", new Object[0]);
        }
    }

    public static Config from(Path path) {
        TomlConfig tomlConfig;
        block8: {
            Require.nonNull("Path to read", path);
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                tomlConfig = new TomlConfig(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException(String.format("Unable to parse: %s", path), new Object[]{e});
                }
            }
            ((Reader)reader).close();
        }
        return tomlConfig;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section to read", section);
        Require.nonNull("Option to read", option);
        if (!this.toml.containsKey(section)) {
            return Optional.empty();
        }
        Object raw = this.toml.get(section);
        if (!(raw instanceof TomlTable)) {
            throw new ConfigException(String.format("Section %s is not a section! %s", section, raw), new Object[0]);
        }
        TomlTable table = this.toml.getTomlTable(section, new Object[0]);
        Object value = table.getOrDefault(option, null);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Collection) {
            Collection collection = value;
            if (collection.stream().anyMatch(item -> item instanceof TomlTable)) {
                ArrayList toReturn = new ArrayList();
                collection.stream().map(item -> (TomlTable)item).forEach(tomlTable -> tomlTable.toMap().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).sorted().forEach(toReturn::add));
                return Optional.of(toReturn);
            }
            List values = collection.stream().filter(item -> !(item instanceof Collection)).map(String::valueOf).collect(ImmutableList.toImmutableList());
            return Optional.of(values);
        }
        return Optional.of(ImmutableList.of(String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSortedSet.copyOf(this.toml.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        Object raw = this.toml.get(section);
        if (!(raw instanceof TomlTable)) {
            return ImmutableSortedSet.of();
        }
        return ImmutableSortedSet.copyOf(((TomlTable)raw).keySet());
    }
}

