/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.cachestorage.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum CachedResponseType {
    BASIC("basic"),
    CORS("cors"),
    DEFAULT("default"),
    ERROR("error"),
    OPAQUERESPONSE("opaqueResponse"),
    OPAQUEREDIRECT("opaqueRedirect");

    private String value;

    private CachedResponseType(String value) {
        this.value = value;
    }

    public static CachedResponseType fromString(String s2) {
        return Arrays.stream(CachedResponseType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CachedResponseType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CachedResponseType fromJson(JsonInput input) {
        return CachedResponseType.fromString(input.nextString());
    }
}

