/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.webauthn.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum AuthenticatorProtocol {
    U2F("u2f"),
    CTAP2("ctap2");

    private String value;

    private AuthenticatorProtocol(String value) {
        this.value = value;
    }

    public static AuthenticatorProtocol fromString(String s2) {
        return Arrays.stream(AuthenticatorProtocol.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within AuthenticatorProtocol "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static AuthenticatorProtocol fromJson(JsonInput input) {
        return AuthenticatorProtocol.fromString(input.nextString());
    }
}

