/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.idealized;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.ScriptId;
import org.openqa.selenium.internal.Require;

public abstract class Javascript<SCRIPTID, BINDINGCALLED> {
    private final DevTools devtools;
    private final Map<String, ScriptId> pinnedScripts = new HashMap<String, ScriptId>();
    private final Set<String> bindings = new HashSet<String>();

    public Javascript(DevTools devtools) {
        this.devtools = Require.nonNull("DevTools", devtools);
    }

    public void disable() {
        this.devtools.send(this.disableRuntime());
        this.devtools.send(this.disablePage());
        this.pinnedScripts.values().forEach(id -> this.removeScriptToEvaluateOnNewDocument(id.getActualId()));
        this.pinnedScripts.clear();
    }

    protected abstract Command<Void> disablePage();

    protected abstract Command<Void> disableRuntime();

    public ScriptId pin(String exposeScriptAs, String script) {
        Require.nonNull("Script name", exposeScriptAs);
        Require.nonNull("Script", script);
        if (this.pinnedScripts.containsKey(script)) {
            return this.pinnedScripts.get(script);
        }
        this.devtools.send(this.enableRuntime());
        this.devtools.send(this.doAddJsBinding(exposeScriptAs));
        this.devtools.send(this.enablePage());
        SCRIPTID id = this.devtools.send(this.addScriptToEvaluateOnNewDocument(script));
        ScriptId scriptId = new ScriptId(id);
        this.pinnedScripts.put(script, scriptId);
        return scriptId;
    }

    public void addBindingCalledListener(Consumer<String> listener) {
        Require.nonNull("Listener", listener);
        this.devtools.send(this.enableRuntime());
        this.devtools.addListener(this.bindingCalledEvent(), event -> {
            String payload = this.extractPayload(event);
            listener.accept(payload);
        });
    }

    public void addJsBinding(String scriptName) {
        Require.nonNull("Script name", scriptName);
        this.bindings.add(scriptName);
        this.doAddJsBinding(scriptName);
    }

    public void removeJsBinding(String scriptName) {
        Require.nonNull("Script name", scriptName);
        this.bindings.remove(scriptName);
        this.doRemoveJsBinding(scriptName);
    }

    protected abstract Command<Void> enableRuntime();

    protected abstract Command<Void> doAddJsBinding(String var1);

    protected abstract Command<Void> doRemoveJsBinding(String var1);

    protected abstract Command<Void> enablePage();

    protected abstract Command<SCRIPTID> addScriptToEvaluateOnNewDocument(String var1);

    protected abstract Command<Void> removeScriptToEvaluateOnNewDocument(SCRIPTID var1);

    protected abstract Event<BINDINGCALLED> bindingCalledEvent();

    protected abstract String extractPayload(BINDINGCALLED var1);
}

