/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.events;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.events.ConsoleEvent;
import org.openqa.selenium.devtools.events.DomMutationEvent;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.logging.EventType;

public class CdpEventTypes {
    private static final Json JSON = new Json();

    private CdpEventTypes() {
    }

    public static EventType<ConsoleEvent> consoleEvent(final Consumer<ConsoleEvent> handler) {
        Require.nonNull("Handler", handler);
        return new EventType<ConsoleEvent>(){

            @Override
            public void consume(ConsoleEvent event) {
                handler.accept(event);
            }

            @Override
            public void initializeListener(WebDriver webDriver) {
                Require.precondition(webDriver instanceof HasDevTools, "Loggable must implement HasDevTools", new Object[0]);
                DevTools tools = ((HasDevTools)((Object)webDriver)).getDevTools();
                tools.createSessionIfThereIsNotOne();
                tools.getDomains().events().addConsoleListener(handler);
            }
        };
    }

    public static EventType<Void> domMutation(final Consumer<DomMutationEvent> handler) {
        String script;
        Require.nonNull("Handler", handler);
        URL url = CdpEventTypes.class.getResource("/org/openqa/selenium/devtools/mutation-listener.js");
        if (url == null) {
            throw new IllegalStateException("Unable to find helper script");
        }
        try {
            script = Resources.toString(url, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read helper script");
        }
        return new EventType<Void>(){

            @Override
            public void consume(Void event) {
                handler.accept(null);
            }

            @Override
            public void initializeListener(WebDriver driver) {
                Require.precondition(driver instanceof HasDevTools, "Loggable must implement HasDevTools", new Object[0]);
                DevTools tools = ((HasDevTools)((Object)driver)).getDevTools();
                tools.createSessionIfThereIsNotOne();
                tools.getDomains().javascript().pin("__webdriver_attribute", script);
                ((JavascriptExecutor)((Object)driver)).executeScript(script, new Object[0]);
                tools.getDomains().javascript().addBindingCalledListener(json -> {
                    Map values = (Map)JSON.toType((String)json, Json.MAP_TYPE);
                    String id = (String)values.get("target");
                    List<WebElement> elements = driver.findElements(By.cssSelector(String.format("*[data-__webdriver_id='%s']", id)));
                    if (!elements.isEmpty()) {
                        DomMutationEvent event = new DomMutationEvent(elements.get(0), String.valueOf(values.get("name")), String.valueOf(values.get("value")), String.valueOf(values.get("oldValue")));
                        handler.accept(event);
                    }
                });
            }
        };
    }
}

