/*
 * Decompiled with CFR 0.152.
 */
package com.neilalexander.jnacl.crypto;

import com.neilalexander.jnacl.crypto.curve25519;
import com.neilalexander.jnacl.crypto.hsalsa20;
import com.neilalexander.jnacl.crypto.xsalsa20;
import com.neilalexander.jnacl.crypto.xsalsa20poly1305;
import java.security.SecureRandom;

public class curve25519xsalsa20poly1305 {
    public static final int crypto_secretbox_PUBLICKEYBYTES = 32;
    public static final int crypto_secretbox_SECRETKEYBYTES = 32;
    public static final int crypto_secretbox_BEFORENMBYTES = 32;
    public static final int crypto_secretbox_NONCEBYTES = 24;
    public static final int crypto_secretbox_ZEROBYTES = 32;
    public static final int crypto_secretbox_BOXZEROBYTES = 16;

    public static int crypto_box_getpublickey(byte[] pk, byte[] sk) {
        return curve25519.crypto_scalarmult_base(pk, sk);
    }

    public static int crypto_box_keypair(byte[] pk, byte[] sk) {
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(sk);
        return curve25519.crypto_scalarmult_base(pk, sk);
    }

    public static int crypto_box_afternm(byte[] c, byte[] m3, long mlen, byte[] n, byte[] k) {
        return xsalsa20poly1305.crypto_secretbox(c, m3, mlen, n, k);
    }

    public static int crypto_box_beforenm(byte[] k, byte[] pk, byte[] sk) {
        byte[] sp = new byte[32];
        byte[] sigmap = xsalsa20.sigma;
        curve25519.crypto_scalarmult(sp, sk, pk);
        return hsalsa20.crypto_core(k, null, sp, sigmap);
    }

    public static int crypto_box(byte[] c, byte[] m3, long mlen, byte[] n, byte[] pk, byte[] sk) {
        byte[] kp = new byte[32];
        curve25519xsalsa20poly1305.crypto_box_beforenm(kp, pk, sk);
        return curve25519xsalsa20poly1305.crypto_box_afternm(c, m3, mlen, n, kp);
    }

    public static int crypto_box_open(byte[] m3, byte[] c, long clen, byte[] n, byte[] pk, byte[] sk) {
        byte[] kp = new byte[32];
        curve25519xsalsa20poly1305.crypto_box_beforenm(kp, pk, sk);
        return curve25519xsalsa20poly1305.crypto_box_open_afternm(m3, c, clen, n, kp);
    }

    public static int crypto_box_open_afternm(byte[] m3, byte[] c, long clen, byte[] n, byte[] k) {
        return xsalsa20poly1305.crypto_secretbox_open(m3, c, clen, n, k);
    }

    public static int crypto_box_afternm(byte[] c, byte[] m3, byte[] n, byte[] k) {
        return curve25519xsalsa20poly1305.crypto_box_afternm(c, m3, m3.length, n, k);
    }

    public static int crypto_box_open_afternm(byte[] m3, byte[] c, byte[] n, byte[] k) {
        return curve25519xsalsa20poly1305.crypto_box_open_afternm(m3, c, c.length, n, k);
    }

    public static int crypto_box(byte[] c, byte[] m3, byte[] n, byte[] pk, byte[] sk) {
        return curve25519xsalsa20poly1305.crypto_box(c, m3, m3.length, n, pk, sk);
    }

    public static int crypto_box_open(byte[] m3, byte[] c, byte[] n, byte[] pk, byte[] sk) {
        return curve25519xsalsa20poly1305.crypto_box_open(m3, c, c.length, n, pk, sk);
    }
}

