/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.target.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v85.target.model.SessionID;
import org.openqa.selenium.devtools.v85.target.model.TargetInfo;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttachedToTarget {
    private final SessionID sessionId;
    private final TargetInfo targetInfo;
    private final Boolean waitingForDebugger;

    public AttachedToTarget(SessionID sessionId, TargetInfo targetInfo, Boolean waitingForDebugger) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
        this.targetInfo = Objects.requireNonNull(targetInfo, "targetInfo is required");
        this.waitingForDebugger = Objects.requireNonNull(waitingForDebugger, "waitingForDebugger is required");
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    public TargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    public Boolean getWaitingForDebugger() {
        return this.waitingForDebugger;
    }

    private static AttachedToTarget fromJson(JsonInput input) {
        SessionID sessionId = null;
        TargetInfo targetInfo = null;
        Boolean waitingForDebugger = false;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sessionId": {
                    sessionId = (SessionID)input.read((Type)((Object)SessionID.class));
                    continue block10;
                }
                case "targetInfo": {
                    targetInfo = (TargetInfo)input.read((Type)((Object)TargetInfo.class));
                    continue block10;
                }
                case "waitingForDebugger": {
                    waitingForDebugger = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttachedToTarget(sessionId, targetInfo, waitingForDebugger);
    }
}

