/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.stats;

import org.dataloader.impl.Assertions;
import org.dataloader.stats.SimpleStatisticsCollector;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;

public class DelegatingStatisticsCollector
implements StatisticsCollector {
    private final StatisticsCollector collector = new SimpleStatisticsCollector();
    private final StatisticsCollector delegateCollector;

    public DelegatingStatisticsCollector(StatisticsCollector delegateCollector) {
        this.delegateCollector = Assertions.nonNull(delegateCollector);
    }

    @Override
    public long incrementLoadCount() {
        this.delegateCollector.incrementLoadCount();
        return this.collector.incrementLoadCount();
    }

    @Override
    public long incrementBatchLoadCountBy(long delta) {
        this.delegateCollector.incrementBatchLoadCountBy(delta);
        return this.collector.incrementBatchLoadCountBy(delta);
    }

    @Override
    public long incrementCacheHitCount() {
        this.delegateCollector.incrementCacheHitCount();
        return this.collector.incrementCacheHitCount();
    }

    @Override
    public long incrementLoadErrorCount() {
        this.delegateCollector.incrementLoadErrorCount();
        return this.collector.incrementLoadErrorCount();
    }

    @Override
    public long incrementBatchLoadExceptionCount() {
        this.delegateCollector.incrementBatchLoadExceptionCount();
        return this.collector.incrementBatchLoadExceptionCount();
    }

    @Override
    public Statistics getStatistics() {
        return this.collector.getStatistics();
    }

    public Statistics getDelegateStatistics() {
        return this.delegateCollector.getStatistics();
    }
}

