/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ExecutionInput;
import graphql.ParseAndValidateResult;
import graphql.PublicApi;
import graphql.language.Document;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.List;

@PublicApi
public class ParseAndValidate {
    public static ParseAndValidateResult parseAndValidate(GraphQLSchema graphQLSchema, ExecutionInput executionInput) {
        ParseAndValidateResult result = ParseAndValidate.parse(executionInput);
        if (!result.isFailure()) {
            List<ValidationError> errors = ParseAndValidate.validate(graphQLSchema, result.getDocument());
            return result.transform(builder -> builder.validationErrors(errors));
        }
        return result;
    }

    public static ParseAndValidateResult parse(ExecutionInput executionInput) {
        try {
            Parser parser = new Parser();
            Document document = parser.parseDocument(executionInput.getQuery());
            return ParseAndValidateResult.newResult().document(document).variables(executionInput.getVariables()).build();
        }
        catch (InvalidSyntaxException e) {
            return ParseAndValidateResult.newResult().syntaxException(e).variables(executionInput.getVariables()).build();
        }
    }

    public static List<ValidationError> validate(GraphQLSchema graphQLSchema, Document parsedDocument) {
        Validator validator = new Validator();
        return validator.validateDocument(graphQLSchema, parsedDocument);
    }
}

