/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class NewSessionResponse {
    private final RequestId requestId;
    private final Session session;
    private final byte[] downstreamEncodedResponse;

    public NewSessionResponse(RequestId requestId, Session session, byte[] downstreamEncodedResponse) {
        this.requestId = Require.nonNull("Request Id", requestId);
        this.session = Require.nonNull("Session", session);
        this.downstreamEncodedResponse = Require.nonNull("Downstream encoded response", downstreamEncodedResponse);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Session getSession() {
        return this.session;
    }

    public byte[] getDownstreamEncodedResponse() {
        return this.downstreamEncodedResponse;
    }

    private Map<String, Object> toJson() {
        LinkedHashMap<String, Object> toReturn = new LinkedHashMap<String, Object>();
        toReturn.put("requestId", this.requestId);
        toReturn.put("session", this.session);
        toReturn.put("downstreamEncodedResponse", Base64.getEncoder().encodeToString(this.downstreamEncodedResponse));
        return Collections.unmodifiableMap(toReturn);
    }

    private static NewSessionResponse fromJson(JsonInput input) {
        RequestId requestId = null;
        Session session = null;
        byte[] downstreamResponse = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block10;
                }
                case "session": {
                    session = (Session)input.read((Type)((Object)Session.class));
                    continue block10;
                }
                case "downstreamEncodedResponse": {
                    downstreamResponse = Base64.getDecoder().decode(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NewSessionResponse(requestId, session, downstreamResponse);
    }
}

