/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.Try;
import org.dataloader.annotations.PublicSpi;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.impl.NoOpValueCache;

@PublicSpi
public interface ValueCache<K, V> {
    public static <K, V> ValueCache<K, V> defaultValueCache() {
        return NoOpValueCache.NOOP;
    }

    public CompletableFuture<V> get(K var1);

    default public CompletableFuture<List<Try<V>>> getValues(List<K> keys) {
        ArrayList cacheLookups = new ArrayList();
        for (K key : keys) {
            CompletableFuture<Try<V>> cacheTry = Try.tryFuture(this.get(key));
            cacheLookups.add(cacheTry);
        }
        return CompletableFutureKit.allOf(cacheLookups);
    }

    public CompletableFuture<V> set(K var1, V var2);

    default public CompletableFuture<List<V>> setValues(List<K> keys, List<V> values) {
        ArrayList cacheSets = new ArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            K k = keys.get(i);
            Object v = values.get(i);
            CompletableFuture<V> setCall = this.set(k, v);
            CompletionStage set = Try.tryFuture(setCall).thenApply(ignored -> v);
            cacheSets.add(set);
        }
        return CompletableFutureKit.allOf(cacheSets);
    }

    public CompletableFuture<Void> delete(K var1);

    public CompletableFuture<Void> clear();
}

