/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.MinMaxSumCountAccumulation;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class LongMinMaxSumCountAggregator
extends AbstractMinMaxSumCountAggregator {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    LongMinMaxSumCountAggregator(Supplier<ExemplarReservoir> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<MinMaxSumCountAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    static final class Handle
    extends AggregatorHandle<MinMaxSumCountAccumulation> {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final LongState current = new LongState();

        Handle(ExemplarReservoir exemplarReservoir) {
            super(exemplarReservoir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected MinMaxSumCountAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            this.lock.writeLock().lock();
            try {
                MinMaxSumCountAccumulation toReturn = MinMaxSumCountAccumulation.create(this.current.count, this.current.sum, this.current.min, this.current.max);
                this.current.reset();
                MinMaxSumCountAccumulation minMaxSumCountAccumulation = toReturn;
                return minMaxSumCountAccumulation;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.lock.writeLock().lock();
            try {
                this.current.record(value);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private static final class LongState {
            private long count;
            private long sum;
            private long min;
            private long max;

            public LongState() {
                this.reset();
            }

            private void reset() {
                this.sum = 0L;
                this.count = 0L;
                this.min = Long.MAX_VALUE;
                this.max = Long.MIN_VALUE;
            }

            public void record(long value) {
                ++this.count;
                this.sum += value;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
            }
        }
    }
}

