/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLCodeRegistry {
    private final Map<FieldCoordinates, DataFetcherFactory<?>> dataFetcherMap;
    private final Map<String, DataFetcherFactory<?>> systemDataFetcherMap;
    private final Map<String, TypeResolver> typeResolverMap;
    private final GraphqlFieldVisibility fieldVisibility;
    private final DataFetcherFactory<?> defaultDataFetcherFactory;

    private GraphQLCodeRegistry(Builder builder) {
        this.dataFetcherMap = builder.dataFetcherMap;
        this.systemDataFetcherMap = builder.systemDataFetcherMap;
        this.typeResolverMap = builder.typeResolverMap;
        this.fieldVisibility = builder.fieldVisibility;
        this.defaultDataFetcherFactory = builder.defaultDataFetcherFactory;
    }

    public GraphqlFieldVisibility getFieldVisibility() {
        return this.fieldVisibility;
    }

    public DataFetcher<?> getDataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition) {
        return GraphQLCodeRegistry.getDataFetcherImpl(FieldCoordinates.coordinates(parentType, fieldDefinition), fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap, this.defaultDataFetcherFactory);
    }

    public DataFetcher<?> getDataFetcher(FieldCoordinates coordinates, GraphQLFieldDefinition fieldDefinition) {
        return GraphQLCodeRegistry.getDataFetcherImpl(coordinates, fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap, this.defaultDataFetcherFactory);
    }

    public boolean hasDataFetcher(FieldCoordinates coordinates) {
        return GraphQLCodeRegistry.hasDataFetcherImpl(coordinates, this.dataFetcherMap, this.systemDataFetcherMap);
    }

    private static DataFetcher<?> getDataFetcherImpl(FieldCoordinates coordinates, GraphQLFieldDefinition fieldDefinition, Map<FieldCoordinates, DataFetcherFactory<?>> dataFetcherMap, Map<String, DataFetcherFactory<?>> systemDataFetcherMap, DataFetcherFactory<?> defaultDataFetcherFactory) {
        Assert.assertNotNull(coordinates);
        Assert.assertNotNull(fieldDefinition);
        DataFetcherFactory<?> dataFetcherFactory = systemDataFetcherMap.get(fieldDefinition.getName());
        if (dataFetcherFactory == null && (dataFetcherFactory = dataFetcherMap.get(coordinates)) == null) {
            dataFetcherFactory = defaultDataFetcherFactory;
        }
        return dataFetcherFactory.get(DataFetcherFactoryEnvironment.newDataFetchingFactoryEnvironment().fieldDefinition(fieldDefinition).build());
    }

    private static boolean hasDataFetcherImpl(FieldCoordinates coords, Map<FieldCoordinates, DataFetcherFactory<?>> dataFetcherMap, Map<String, DataFetcherFactory<?>> systemDataFetcherMap) {
        Assert.assertNotNull(coords);
        DataFetcherFactory<?> dataFetcherFactory = systemDataFetcherMap.get(coords.getFieldName());
        if (dataFetcherFactory == null) {
            dataFetcherFactory = dataFetcherMap.get(coords);
        }
        return dataFetcherFactory != null;
    }

    public TypeResolver getTypeResolver(GraphQLInterfaceType interfaceType) {
        return GraphQLCodeRegistry.getTypeResolverForInterface(interfaceType, this.typeResolverMap);
    }

    public TypeResolver getTypeResolver(GraphQLUnionType unionType) {
        return GraphQLCodeRegistry.getTypeResolverForUnion(unionType, this.typeResolverMap);
    }

    private static TypeResolver getTypeResolverForInterface(GraphQLInterfaceType parentType, Map<String, TypeResolver> typeResolverMap) {
        Assert.assertNotNull(parentType);
        TypeResolver typeResolver = typeResolverMap.get(parentType.getName());
        if (typeResolver == null) {
            typeResolver = parentType.getTypeResolver();
        }
        return Assert.assertNotNull(typeResolver, () -> "There must be a type resolver for interface " + parentType.getName());
    }

    private static TypeResolver getTypeResolverForUnion(GraphQLUnionType parentType, Map<String, TypeResolver> typeResolverMap) {
        Assert.assertNotNull(parentType);
        TypeResolver typeResolver = typeResolverMap.get(parentType.getName());
        if (typeResolver == null) {
            typeResolver = parentType.getTypeResolver();
        }
        return Assert.assertNotNull(typeResolver, () -> "There must be a type resolver for union " + parentType.getName());
    }

    public GraphQLCodeRegistry transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLCodeRegistry.newCodeRegistry(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newCodeRegistry() {
        return new Builder();
    }

    public static Builder newCodeRegistry(GraphQLCodeRegistry existingCodeRegistry) {
        return new Builder(existingCodeRegistry);
    }

    public static class Builder {
        private final Map<FieldCoordinates, DataFetcherFactory<?>> dataFetcherMap = new LinkedHashMap();
        private final Map<String, DataFetcherFactory<?>> systemDataFetcherMap = new LinkedHashMap();
        private final Map<String, TypeResolver> typeResolverMap = new HashMap<String, TypeResolver>();
        private GraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        private DataFetcherFactory<?> defaultDataFetcherFactory = env -> PropertyDataFetcher.fetching(env.getFieldDefinition().getName());
        private boolean changed = false;

        private Builder() {
        }

        private Builder(GraphQLCodeRegistry codeRegistry) {
            this.systemDataFetcherMap.putAll(codeRegistry.systemDataFetcherMap);
            this.dataFetcherMap.putAll(codeRegistry.dataFetcherMap);
            this.typeResolverMap.putAll(codeRegistry.typeResolverMap);
            this.fieldVisibility = codeRegistry.fieldVisibility;
            this.defaultDataFetcherFactory = codeRegistry.defaultDataFetcherFactory;
        }

        @Internal
        public Builder trackChanges() {
            this.changed = false;
            return this;
        }

        @Internal
        public boolean hasChanged() {
            return this.changed;
        }

        private Builder markChanged() {
            this.changed = true;
            return this;
        }

        private Builder markChanged(boolean condition) {
            if (condition) {
                this.changed = true;
            }
            return this;
        }

        public DataFetcher<?> getDataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition) {
            return GraphQLCodeRegistry.getDataFetcherImpl(FieldCoordinates.coordinates(parentType, fieldDefinition), fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap, this.defaultDataFetcherFactory);
        }

        public DataFetcher<?> getDataFetcher(FieldCoordinates coordinates, GraphQLFieldDefinition fieldDefinition) {
            return GraphQLCodeRegistry.getDataFetcherImpl(coordinates, fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap, this.defaultDataFetcherFactory);
        }

        public DataFetcherFactory<?> getDefaultDataFetcherFactory() {
            return this.defaultDataFetcherFactory;
        }

        public boolean hasDataFetcher(FieldCoordinates coordinates) {
            return GraphQLCodeRegistry.hasDataFetcherImpl(coordinates, this.dataFetcherMap, this.systemDataFetcherMap);
        }

        public TypeResolver getTypeResolver(GraphQLInterfaceType interfaceType) {
            return GraphQLCodeRegistry.getTypeResolverForInterface(interfaceType, this.typeResolverMap);
        }

        public boolean hasTypeResolver(String typeName) {
            return this.typeResolverMap.containsKey(typeName);
        }

        public TypeResolver getTypeResolver(GraphQLUnionType unionType) {
            return GraphQLCodeRegistry.getTypeResolverForUnion(unionType, this.typeResolverMap);
        }

        public Builder dataFetcher(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher);
            return this.dataFetcher(Assert.assertNotNull(coordinates), DataFetcherFactories.useDataFetcher(dataFetcher));
        }

        public Builder dataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition, DataFetcher<?> dataFetcher) {
            return this.dataFetcher(FieldCoordinates.coordinates(parentType.getName(), fieldDefinition.getName()), dataFetcher);
        }

        public Builder systemDataFetcher(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher);
            Assert.assertNotNull(coordinates);
            coordinates.assertValidNames();
            this.systemDataFetcherMap.put(coordinates.getFieldName(), DataFetcherFactories.useDataFetcher(dataFetcher));
            return this.markChanged();
        }

        public Builder dataFetcher(FieldCoordinates coordinates, DataFetcherFactory<?> dataFetcherFactory) {
            Assert.assertNotNull(dataFetcherFactory);
            Assert.assertNotNull(coordinates);
            coordinates.assertValidNames();
            if (coordinates.isSystemCoordinates()) {
                this.systemDataFetcherMap.put(coordinates.getFieldName(), dataFetcherFactory);
            } else {
                this.dataFetcherMap.put(coordinates, dataFetcherFactory);
            }
            return this.markChanged();
        }

        public Builder dataFetcherIfAbsent(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            if (!this.hasDataFetcher(coordinates)) {
                if (coordinates.isSystemCoordinates()) {
                    this.systemDataFetcher(coordinates, dataFetcher);
                } else {
                    this.dataFetcher(coordinates, dataFetcher);
                }
                return this.markChanged();
            }
            return this;
        }

        public Builder dataFetchers(String parentTypeName, Map<String, DataFetcher<?>> fieldDataFetchers) {
            Assert.assertNotNull(fieldDataFetchers);
            fieldDataFetchers.forEach((fieldName, dataFetcher) -> this.dataFetcher(FieldCoordinates.coordinates(parentTypeName, fieldName), (DataFetcher<?>)dataFetcher));
            return this.markChanged(!fieldDataFetchers.isEmpty());
        }

        public Builder defaultDataFetcher(DataFetcherFactory<?> defaultDataFetcherFactory) {
            this.defaultDataFetcherFactory = Assert.assertNotNull(defaultDataFetcherFactory);
            return this.markChanged();
        }

        public Builder dataFetchers(GraphQLCodeRegistry codeRegistry) {
            this.dataFetcherMap.putAll(codeRegistry.dataFetcherMap);
            return this.markChanged(!codeRegistry.dataFetcherMap.isEmpty());
        }

        public Builder typeResolver(GraphQLInterfaceType interfaceType, TypeResolver typeResolver) {
            this.typeResolverMap.put(interfaceType.getName(), typeResolver);
            return this.markChanged();
        }

        public Builder typeResolverIfAbsent(GraphQLInterfaceType interfaceType, TypeResolver typeResolver) {
            if (!this.typeResolverMap.containsKey(interfaceType.getName())) {
                this.typeResolverMap.put(interfaceType.getName(), typeResolver);
                return this.markChanged();
            }
            return this;
        }

        public Builder typeResolver(GraphQLUnionType unionType, TypeResolver typeResolver) {
            this.typeResolverMap.put(unionType.getName(), typeResolver);
            return this.markChanged();
        }

        public Builder typeResolverIfAbsent(GraphQLUnionType unionType, TypeResolver typeResolver) {
            if (!this.typeResolverMap.containsKey(unionType.getName())) {
                this.typeResolverMap.put(unionType.getName(), typeResolver);
                return this.markChanged();
            }
            return this.markChanged();
        }

        public Builder typeResolver(String typeName, TypeResolver typeResolver) {
            this.typeResolverMap.put(Assert.assertValidName(typeName), typeResolver);
            return this.markChanged();
        }

        public Builder typeResolvers(GraphQLCodeRegistry codeRegistry) {
            this.typeResolverMap.putAll(codeRegistry.typeResolverMap);
            return this.markChanged(!codeRegistry.typeResolverMap.isEmpty());
        }

        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.fieldVisibility = Assert.assertNotNull(fieldVisibility);
            return this.markChanged();
        }

        public Builder clearDataFetchers() {
            this.dataFetcherMap.clear();
            return this.markChanged();
        }

        public Builder clearTypeResolvers() {
            this.typeResolverMap.clear();
            return this.markChanged();
        }

        public GraphQLCodeRegistry build() {
            return new GraphQLCodeRegistry(this);
        }
    }
}

