import sys
import tensorflow as tf
# Dodaj inne biblioteki modułów, których możesz potrzebować

cluster = tf.train.ClusterSpec(
          {'ps':['192.168.1.3:2222'],
           'worker': ['192.168.1.4:2222',
                      '192.168.1.5:2222',
                      '192.168.1.6:2222',
                      '192.168.1.7:2222']
 })

job = sys.argv[1]
task_idx = sys.argv[2]

server = tf.train.Server(cluster, job_name=job, task_index= int(task_idx))

if job == 'ps':  
    # Sprawia, że serwer parametrów czeka, 
    # aż serwer się wyłączy
    server.join()
else:
    # Wykonuje kod tylko na komputerach wątków roboczych    
    with tf.device(tf.train.replica_device_setter(cluster=cluster, worker_device='/job:worker/task:'+task_idx)):
        #Zbuduj tu swój model tak, jakbyś pracował na pojedynczym komputerze
        print("W wątku roboczym")

    with tf.Session(server.target):
        # Przeszkol model 
        print("Szkolenie")
