
from utils import *
from model import *


def main():
    # Wczytywanie i wstępne przetwarzanie danych
    print ("Wczytywanie danych")
    processed_data = load_and_preprocess_data()
    print ("Pozyskowanie zbiorów danych: szkoleniowego i testowego")
    X_train, X_test, y_test = get_train_and_test_data(processed_data)

    model_obj = MODEL(X_train,X_test,y_test)
    print ("Szkolenie modelu")
    model_obj.train_model()
    print ("Wczytywanie przeszkolonego modelu")
    model_obj.get_trained_model()
    print ("Pobieranie straty rekonstrukcji dla klas")
    model_obj.plot_reconstruction_error_by_class()
    print ("Pobieranie krzywych precyzji i czułości dla progów")
    model_obj.get_precision_recall_curves()
    print ("Pobieranie macierzy pomyłek z 80-procentową czułością na testowym zbiorze danych")
    model_obj.get_confusion_matrix(min_recall = 0.8)


if __name__==main():
    main()















