#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Ten skrypt pobiera dane wejściowe i szkoli model analizy wydźwięku przy użyciu sieci neuronowych
@author: ankit.jain
"""

from preprocess_functions import *  # Importowanie wszystkich funkcji przetwarzania wstępnego
from model_functions import *  # Importowanie wszystkich funkcji modelu
import tensorflow as tf
import os 
import tensorflowjs as tfjs


# PARAMETRY
current_dir = os.path.dirname(os.path.realpath(__file__))
INPUT_FILE = os.path.join(current_dir, "sentiment.txt")
OUTPUT_DIR = current_dir

def main():
    #Odczyt i wstępne przetwarzanie danych 
    print "=== Odczyt danych wejściowych ==="
    X_text , Y = get_data(INPUT_FILE)
    #Pobranie odpowiedniego słownika z tokenami
    print " ===Tokenizacja recenzji === "
    token_idx,num_tokens = tokenize_text(X_text)
    print 'Liczba unikatowych tokenów: ',num_tokens
    max_tokens = get_max(X_text)
    print "Maksymalna liczba tokenów w recenzji: ", max_tokens
    print "=== Tworzenie sekwencji wejściowych ==="
    input_sequences = create_sequences(X_text, token_idx,max_tokens)
    print "=== Definiowanie modelu ==="
    model = define_model(num_tokens,max_tokens)
    print "=== Szkolenie modelu ==="
    model = train_model(model,input_sequences,Y)
    print "=== Testowanie modelu z niektórymi wejściami, a wyjście to: ==="
    test_model(model,token_idx,max_tokens)
    print "=== Zapisanie modelu ==="
    tfjs.converters.save_keras_model(model, OUTPUT_DIR)    
    #model_save(model, OUTPUT_DIR)
    print "=== Zapisanie słownika indeksu tokenów dla Tensorflow Js"
    create_csv(token_idx, 'token_index.csv',OUTPUT_DIR)


if __name__ == "__main__":
    main()
    
    
    
    
    
    
    
    



    