﻿using Book.Chapter11.LeakingKnowledge;
using Xunit;

namespace Book.Chapter11.CodePollution
{
    public class Logger
    {
        private readonly bool _isTestEnvironment;

        public Logger(bool isTestEnvironment)
        {
            _isTestEnvironment = isTestEnvironment;
        }

        public void Log(string text)
        {
            if (_isTestEnvironment)
                return;

            /* Zapisz tekst do logów */
        }
    }

    public class Controller
    {
        public void SomeMethod(Logger logger)
        {
            logger.Log("Wywołano metodę SomeMethod");
        }
    }

    public class Tests
    {
        [Fact]
        public void Some_test()
        {
            var logger = new Logger(true);
            var spt = new Controller();

            spt.SomeMethod(logger);

            /* sprawdź */
        }
    }

    public interface ILogger
    {
        void Log(string text);
    }

    public class Logger2 : ILogger
    {
        public void Log(string text)
        {
            /* Zapisz tekst do logów */
        }
    }

    public class FakeLogger : ILogger
    {
        public void Log(string text)
        {
            /* Nie rób nic */
        }
    }

    public class Controller2
    {
        public void SomeMethod(ILogger logger)
        {
            logger.Log("Wywołano metodę SomeMethod");
        }
    }
}
