﻿using System.Security.Cryptography;
using System.Text;
using SpeakerMeet.DTO;
using Xunit;

namespace SpeakerMeet.Services.Tests.UserProfileServiceTests
{
    public class IsUserPasswordValid
    {
        private readonly UserProfileService _service;
        private readonly UserProfileDto _profile;

        public IsUserPasswordValid()
        {
            // Arrange
            var repository = new FakeRepository<UserProfileDto>();
            _service = new UserProfileService(repository);
            _profile = new UserProfileDto
            {
                Username = "PoprawnyUzytkownik@email.com",
                // To powinno być wykonane za pomocą metody pomocniczej z klasy narzędziowej
                // Spróbuj napisać test metody mającej zastąpić ten kod
                PasswordHash = SHA512.Create().ComputeHash(Encoding.ASCII.GetBytes("PoprawneHaslo"))
            };

            repository.DataSet.Add(_profile);
        }

        [Fact]
        public void ItReturnsFalseForInvalidPasswords()
        {
            // Act
            var result = _service.IsUserPasswordValid(_profile, "NiepoprawneHaslo");

            // Assert
            Assert.False(result);
        }

        [Fact]
        public void ItReturnsTrueForValidPasswords()
        {
            // Act
            var result = _service.IsUserPasswordValid(_profile, "PoprawneHaslo");

            // Assert
            Assert.True(result);
        }
    }
}
