import React from 'react';
import { expect } from 'chai';
import { mount, shallow } from 'enzyme';

import { SpeakerListRow } from './SpeakerListRow';

function setup(props) {
  const componentProps = {
    speaker: props.speaker || {}
  };

  return shallow(<SpeakerListRow {...componentProps} />);
}

describe('Wiersz listy prelegentów', () => {
  it('istnieje', () => {
    expect(SpeakerListRow).to.exist;
  });

  describe('Podczas renderowania', () => {
    it('renderuje wiersz tabeli', () => {
      // arrange
      const component = setup({
        speaker: {
          id: 'testowy-prelegent',
          firstName: 'Testowy',
          lastName: 'Prelegent'
        }
      });

      // assert
      expect(component.find('.speaker-name').text()).to.equal('Testowy Prelegent');
      expect(component.find('.speaker-link').props().to).to.equal('/speakers/testowy-prelegent');
    });
  });
});
