﻿using Newtonsoft.Json;
using SpeakerMeet.DTO;
using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Http;
using System.Text;
using Xunit;

namespace SpeakerMeet.Api.IntegrationTest.Controller
{
    [Collection("Controllers")]
    [Trait("Category", "Integration")]
    public class GetAll : IClassFixture<ServerFixture>
    {
        private readonly HttpClient _client;

        public GetAll(ServerFixture fixture)
        {
            _client = fixture.Client;
        }

        [Fact]
        public async void ItShouldCallGetSpeakers()
        {
            // Act
            var response = await _client.GetAsync("/api/speaker");

            Assert.NotNull(response);
        }

        [Fact]
        public async void ItShouldReturnSuccess()
        {
            // Act
            var response = await _client.GetAsync("/api/speaker/");
            response.EnsureSuccessStatusCode();
            
            // Assert
            Assert.Equal(HttpStatusCode.OK, response.StatusCode);
        }

        [Fact]
        public async void ItShouldReturnSpeakers()
        {
            // Act
            var response = await _client.GetAsync("/api/speaker");

            response.EnsureSuccessStatusCode();

            var responseString = await response.Content.ReadAsStringAsync();
            var speakers = JsonConvert.DeserializeObject<List<SpeakerSummary>>(responseString);

            // Assert
            Assert.Equal(1, speakers[0].Id);
        }
    }
}
