﻿using System;
using System.Collections.Generic;
using System.Linq;
using SpeakerMeet.DTO;
using SpeakerMeet.Services.Interfaces;

namespace SpeakerMeet.Services
{
    public class SpeakerService : ISpeakerService
    {
        public IEnumerable<Speaker> Search(string searchString)
        {
            var hardCodedSpeakers = new List<Speaker>
            {
                new Speaker{Name = "Jan"},
                new Speaker{Name = "Janusz"},
                new Speaker{Name = "Janina"},
                new Speaker{Name = "Bartosz"},
            };

            var speakers = hardCodedSpeakers.Where(x =>
                x.Name.StartsWith(searchString,
                    StringComparison.OrdinalIgnoreCase)).ToList();

            return speakers;
        }
    }
}
