﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;

namespace SpeakerMeet.API.Controllers
{
    [Route("api/[controller]")]
    public class SpeakerController : Controller
    {
        // GET api/values
        [HttpGet]
        [Route("search")]
        public IActionResult Search(string searchString)
        {
            var hardCodedSpeakers = new List<Speaker>
            {
                new Speaker{Name = "Jan"},
                new Speaker{Name = "Janusz"},
                new Speaker{Name = "Janina"},
                new Speaker{Name = "Bartosz"},
            };

            var speakers = hardCodedSpeakers
                .Where(x => x.Name.StartsWith(searchString, StringComparison.OrdinalIgnoreCase)).ToList();

            return Ok(speakers);
        }
    }

    public class Speaker
    {
        public string Name { get; set; }
    }
}