﻿using System.Linq;
using System.Security.Cryptography;
using System.Text;
using SpeakerMeet.DTO;
using SpeakerMeet.Repositories.Interfaces;

namespace SpeakerMeet.Services
{
    public class UserProfileService
    {
        private readonly IRepository<UserProfileDto> _repository;

        public UserProfileService(IRepository<UserProfileDto> repository)
        {
            _repository = repository;
        }

        public UserProfileDto GetUserProfile(string username)
        {
            return _repository.GetAll().FirstOrDefault(u => u.Username == username);
        }

        public bool IsUserPasswordValid(UserProfileDto profile, string password)
        {
            // Teraz kod z testów mamy również w kodzie produkcyjnym
            var hash = SHA512.Create().ComputeHash(Encoding.ASCII.GetBytes(password));

            return profile.PasswordHash.SequenceEqual(hash);
        }
    }
}
