import { expect } from 'chai';

describe('Sprawdzenie frameworka', () => {
  it('is configured correctly', () => {
    expect(1).to.equal(1);
  });
});

describe('Czy palindrom', () => {
  it('istnieje', () => {
    expect(isPalindrome).to.exist;
  });

  it('pojedyncza litera jest palindromem', () => {
    // arrange
    const value = 'a';

    // act
    const result = isPalindrome(value);

    // assert
    expect(result).to.be.true;
  });

  it('dwie różne litery nie są palindromem', () => {
    // arrange
    const value = 'at';

    // act
    const result = isPalindrome(value);

    // assert
    expect(result).to.be.false;
  });

  it('dwie takie same litery są palindromem', () => {
    // arrange
    const value = 'oo';

    // act
    const result = isPalindrome(value);

    // assert
    expect(result).to.be.true;
  });

  it('trzyliterowy palindrom', () => {
    // arrange
    const value = 'aga';

    // act
    const result = isPalindrome(value);

    // assert
    expect(result).to.be.true;
  });

  it('czteroliterowy palindrom', () => {
    // arrange
    const value = 'abba';
   
    // act
    const result = isPalindrome(value);
   
    // assert
    expect(result).to.be.true;
  });
});

function isPalindrome(value) {
  if (value.length === 1) {
    return true;
  }

  if (value.length === 2 && value[0] === value[1]) {
    return true;
  }

  if (value[0] === value[value.length - 1]) {
    return isPalindrome(value.substring(1, value.length - 1));
  }

  return false;
}
