import time
from .base import FunctionalTest

TEST_EMAIL = 'edyta@mockmyid.com'


class LoginTest(FunctionalTest):

    def switch_to_new_window(self, text_in_title):
        retries = 60
        while retries > 0:
            for handle in self.browser.window_handles:
                self.browser.switch_to_window(handle)
                if text_in_title in self.browser.title:
                    return
            retries -= 1
            time.sleep(0.5)
        self.fail('nie można znaleźć okna')


    def test_login_with_persona(self):
        # Edyta odwiedza wspaniałą witrynę superlists
        # i po raz pierwszy zauważa łącze "Zaloguj".
        self.browser.get(self.server_url)
        self.browser.find_element_by_id('id_login').click()

        # Na ekranie pojawia się okno dialogowe logowania za pomocą usługi Persona.
        self.switch_to_new_window('Mozilla Persona')

        # Edyta loguje się, podając adres e-mail.
        ## Użycie mockmyid.com do przetestowania adresu e-mail.
        self.browser.find_element_by_id(
            'authentication_email'
        ).send_keys(TEST_EMAIL)
        self.browser.find_element_by_tag_name('button').click()

        # Okno dialogowe usługi Persona zostaje zamknięte.
        self.switch_to_new_window('Listy')

        # Edyta może zobaczyć, że została zalogowana.
        self.wait_to_be_logged_in(email=TEST_EMAIL)

        # Odświeżenie strony. Użytkownik widzi, że to prawdziwa sesja logowania,
        # a nie tylko jednorazowa operacja na danej stronie.
        self.browser.refresh()
        self.wait_to_be_logged_in(email=TEST_EMAIL)

        # Przerażony tą funkcją użytkownik klika przycisk wylogowania.
        self.browser.find_element_by_id('id_logout').click()
        self.wait_to_be_logged_out(email=TEST_EMAIL)

        # Stan "wylogowany" został zachowany także po odświeżeniu strony.
        self.browser.refresh()
        self.wait_to_be_logged_out(email=TEST_EMAIL)

