package com.packtpublishing.tddjava.ch04ship;

public class Ship {

    private final Location location;
    public Location getLocation() {
        return location;
    }

    public Ship(Location location) {
        this.location = location;
    }

    public boolean moveForward() {
        return location.forward();
    }

    public boolean moveBackward() {
        return location.backward();
    }

    public void turnLeft() {
        location.turnLeft();
    }

    public void turnRight() {
        location.turnRight();
    }

    public void receiveCommands(String commands) {
        for (char command : commands.toCharArray()) {
            switch(command) {
                case 'n':
                    moveForward();
                    break;
                case 'w':
                    moveBackward();
                    break;
                case 'l':
                    turnLeft();
                    break;
                case 'p':
                    turnRight();
                    break;
            }
        }
    }

}
