package com.packtpublishing.tddjava.ch02friendships;

import org.junit.*;

import java.util.Arrays;
import java.util.List;

public class FriendshipsTest {
    @BeforeClass
    public static void beforeClass() {
        // Ta metoda jest wykonywana raz w trakcie inicjowania klasy
    }

    @AfterClass
    public static void afterClass() {
        // Ta metoda jest uruchamiana raz po wykonaniu wszystkich testów
    }

    @Before
    public void before() {
        // Ta metoda jest uruchamiana raz przed wykonaniem każdego testu
    }

    @After
    public void after() {
        // Ta metoda jest uruchamiana raz po wykonaniu każdego testu
    }

    @Test
    public void test1() {
        Friendships friendships = new Friendships();

        Assert.assertTrue("Joe nie ma przyjaciół", friendships.getFriendsList("Joe").isEmpty());
    }

    @Test
    public void test2() {
        Friendships friendships = new Friendships();
        friendships.makeFriends("Joe", "Audrey");

        Assert.assertTrue("Joe i Audrey są przyjaciółmi", friendships.areFriends("Joe", "Audrey"));
        Assert.assertTrue("Audrey i Joe są przyjaciółmi", friendships.areFriends("Audrey", "Joe"));

        Assert.assertTrue("Audrey jest przyjacielem Joe", friendships.getFriendsList("Joe").contains("Audrey"));
        Assert.assertEquals("Joe ma jednego przyjaciela", 1, friendships.getFriendsList("Joe").size());

        Assert.assertTrue("Joe jest przyjacielem Audrey", friendships.getFriendsList("Audrey").contains("Joe"));
        Assert.assertEquals("Audrey ma jednego przyjaciela", 1, friendships.getFriendsList("Audrey").size());
    }

    @Test(timeout = 10)
    public void test3() {
        Friendships friendships = new Friendships();
        friendships.makeFriends("Joe", "Audrey");
        friendships.makeFriends("Joe", "Peter");
        friendships.makeFriends("Joe", "Michael");
        friendships.makeFriends("Joe", "Britney");
        friendships.makeFriends("Joe", "Paul");

        Assert.assertEquals("Joe ma pięcioro przyjaciół", 5, friendships.getFriendsList("Joe").size());
        Assert.assertTrue("Joe i Paul są przyjaciółmi", friendships.areFriends("Joe", "Paul"));
        Assert.assertFalse("Joe i Ralph nie są przyjaciółmi", friendships.areFriends("Joe", "Ralph"));

        List<String> friendsOfJoe = Arrays.asList("Audrey", "Peter", "Michael", "Britney", "Paul");
        Assert.assertTrue(friendships.getFriendsList("Joe").containsAll(friendsOfJoe));
    }
}
