package com.packtpublishing.tddjava.ch07bdd;

import static com.codeborne.selenide.Selenide.*;
import static com.codeborne.selenide.Condition.*;
import com.codeborne.selenide.WebDriverRunner;
import org.jbehave.core.annotations.*;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;


public class Steps {

    private WebDriver webDriver;
    private String url = "http://localhost:9001";

    @BeforeStory
    public void beforeStory() {
        if (webDriver == null) {
            webDriver = new PhantomJSDriver();
            WebDriverRunner.setWebDriver(webDriver);
            webDriver.manage().window().setSize(new Dimension(1024, 768));
        }
    }

    @Given(": Zakladajac, ze uzytkownik znajduje sie na stronie z ksiazkami")
    public void givenZakladajacZeUzytkownikZnajdujeSieNaStronieZKsiazkami() {
        open(url);
        $("#books").click();
    }

    @Then(": To istnieje pole $elementId")
    public void thenToIstniejePole(String elementId) {
        $("#" + elementId).shouldBe(visible);
    }

    @When(": Jesli uzytkownik kliknie przycisk $elementId")
    public void whenJesliUzytkownikKlikniePrzycisk(String elementId) {
        $("#" + elementId).click();
    }

    @When(": Jesli uzytkownik wprowadzi wartosci w formularzu z informacjami o ksiazce")
    public void whenJesliUzytkownikWprowadziWartosciWFormularzuZInformacjamiOKsiazce() {
        $("#bookId").setValue("123");
        $("#bookTitle").setValue("Asystent BDD");
        $("#bookAuthor").setValue("Viktor Farcic");
        $("#bookDescription").setValue("Otwarty edytor i mechanizm uruchamiania historii BDD");
    }

    @Then(": To ksiazka zostanie zapisana")
    public void thenToKsiazkaZostanieZapisana() {
        $("#book123").shouldBe(present);
    }

    @When(": Jesli uzytkownik wybierze ksiazke")
    public void whenJesliUzytkownikWybierzeKsiazke() {
        $("#book1").click();
    }

    @Then(": To formularz bedzie zawieral wszystkie dane")
    public void thenToFormularzBedzieZawieralWszystkieDane() {
        $("#bookId").shouldHave(value("1"));
        $("#bookTitle").shouldHave(value("TDD dla programujących w Javie"));
        $("#bookAuthor").shouldHave(value("Viktor Farcic"));
        $("#bookDescription").shouldHave(value("Świetna książka!"));
    }

    @When(": Jesli uzytkownik wprowadzi nowe wartosci w formularzu z informacjami o ksiazce")
    public void whenJesliUzytkownikWprowadziNoweWartosciWFormularzuZInformacjamiOKsiazce() {
        $("#bookTitle").setValue("TDD dla programujących w Javie. Wydanie poprawione");
        $("#bookAuthor").setValue("Viktor Farcic i Alex Garcia");
        $("#bookDescription").setValue("Jeszcze lepsza książka!");
        $("#saveBook").click();
    }

    @Then(": To ksiazka zostanie zaktualizowana")
    public void thenToKsiazkaZostanieZaktualizowana() {
        $("#book1").shouldHave(text("TDD dla programujących w Javie. Wydanie poprawione"));
        $("#book1").click();
        $("#bookTitle").shouldHave(value("TDD dla programujących w Javie. Wydanie poprawione"));
        $("#bookAuthor").shouldHave(value("Viktor Farcic i Alex Garcia"));
        $("#bookDescription").shouldHave(value("Jeszcze lepsza książka!"));
    }

    @Then(": To ksiazka zostanie usunieta")
    public void thenToKsiazkaZostanieUsunieta() {
        $("#book1").shouldNotBe(visible);
    }

}
