package com.packtpublishing.tddjava.ch03tictactoe;

import com.packtpublishing.tddjava.ch03tictactoe.mongo.TicTacToeBean;
import com.packtpublishing.tddjava.ch03tictactoe.mongo.TicTacToeCollection;

import java.net.UnknownHostException;

public class TicTacToe {

    private Character[][] board = {{'\0', '\0', '\0'}, {'\0', '\0', '\0'}, {'\0', '\0', '\0'}};
    private char lastPlayer = '\0';
    private static final int SIZE = 3;
    public static final String NO_WINNER = "Brak zwycięzcy";
    public static final String RESULT_DRAW = "Wynik remisowy";
    private TicTacToeCollection ticTacToeCollection;
    protected TicTacToeCollection getTicTacToeCollection() {
        return ticTacToeCollection;
    }
    private int turn = 0;

    public TicTacToe() throws UnknownHostException {
        this(new TicTacToeCollection());
    }
    protected TicTacToe(TicTacToeCollection collection) {
        ticTacToeCollection = collection;
        if (!ticTacToeCollection.drop()) {
            throw new RuntimeException("Nieudane usuwanie bazy danych");
        }
    }

    public String play(int x, int y) {
        checkAxis(x);
        checkAxis(y);
        lastPlayer = nextPlayer();
//        setBox(x, y, lastPlayer);
        setBox(new TicTacToeBean(++turn, x, y, lastPlayer));
        if (isWin(x, y)) {
            return "Wygrał " + lastPlayer;
        } else if (isDraw()) {
            return RESULT_DRAW;
        } else {
            return NO_WINNER;
        }
    }

    public char nextPlayer() {
        if (lastPlayer == 'X') {
            return 'O';
        }
        return 'X';
    }

    private void checkAxis(int axis) {
        if (axis < 1 || axis > 3) {
            throw new RuntimeException("Wartość X wykracza poza planszę");
        }
    }

//    private void setBox(int x, int y, char lastPlayer) {
//        if (board[x - 1][y - 1] != '\0') {
//            throw new RuntimeException("Pole jest zajęte");
//        } else {
//            board[x - 1][y - 1] = lastPlayer;
//        }
//    }
    private void setBox(TicTacToeBean bean) {
        if (board[bean.getX() - 1][bean.getY() - 1] != '\0') {
            throw new RuntimeException("Pole jest zajęte");
        } else {
            board[bean.getX() - 1][bean.getY() - 1] = lastPlayer;
//            getTicTacToeCollection().saveMove(bean);
            if (!getTicTacToeCollection().saveMove(bean)) {
                throw new RuntimeException("Nieudany zapis do bazy danych");
            }
        }
    }

    private boolean isWin(int x, int y) {
        int playerTotal = lastPlayer * SIZE;
        char horizontal, vertical, diagonal1, diagonal2;
        horizontal = vertical = diagonal1 = diagonal2 = '\0';
        for (int i = 0; i < SIZE; i++) {
            horizontal += board[i][y - 1];
            vertical += board[x - 1][i];
            diagonal1 += board[i][i];
            diagonal2 += board[i][SIZE - i - 1];
        }
        if (horizontal == playerTotal
                || vertical == playerTotal
                || diagonal1 == playerTotal
                || diagonal2 == playerTotal) {
            return true;
        }
        return false;
    }

    private boolean isDraw() {
        for (int x = 0; x < SIZE; x++) {
            for (int y = 0; y < SIZE; y++) {
                if (board[x][y] == '\0') {
                    return false;
                }
            }
        }
        return true;
    }

}
