package com.packtpublishing.tddjava.ch02friendships;

import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;

import static org.hamcrest.CoreMatchers.startsWith;
import static org.junit.Assert.assertThat;

public class SeleniumTest {
    @Test
    public void wikipediaSearchFeature() throws InterruptedException {
        // Deklaracja sterownika przeglądarki używanego do przeglądania zasobów internetu
        WebDriver driver = new FirefoxDriver();

        // Otwieranie strony głównej Wikipedii
        driver.get("http://en.wikipedia.org/wiki/Main_Page");

        // Wyszukiwanie wyrażenia "Test-driven development"
        WebElement query = driver.findElement(By.name("search"));
        query.sendKeys("Test-driven development");

        // Kliknięcie przycisku wyszukiwania
        WebElement goButton = driver.findElement(By.name("go"));
        goButton.click();

        // Sprawdzanie wyniku
        assertThat(driver.getTitle(), startsWith("Test-driven development"));

        driver.quit();
    }
}
