package com.packtpublishing.tddjava.ch02friendships;

import org.junit.*;

import java.util.Arrays;
import java.util.List;

public class FriendshipsTest {

    Friendships friendships;

    @BeforeClass
    public static void beforeClass() {
        // Ta metoda jest wykonywana raz w trakcie inicjowania klasy
    }

    @Before
    public void before() {
        friendships = new Friendships();
        friendships.makeFriends("Joe", "Audrey");
        friendships.makeFriends("Joe", "Peter");
        friendships.makeFriends("Joe", "Michael");
        friendships.makeFriends("Joe", "Britney");
        friendships.makeFriends("Joe", "Paul");
    }


    @AfterClass
    public static void afterClass() {
        // Ta metoda jest uruchamiana raz po wykonaniu wszystkich testów
    }

    @After
    public void after() {
        // Ta metoda jest uruchamiana raz po wykonaniu każdego testu
    }

    @Test
    public void alexDoesNotHaveFriends() {
        Assert.assertTrue("Alex nie ma przyjaciół", friendships.getFriendsList("Alex").isEmpty());
    }

    @Test
    public void joeHas5Friends() {
        Assert.assertEquals("Joe ma pięcioro przyjaciół", 5, friendships.getFriendsList("Joe").size());
    }

    @Test
    public void joeIsFriendWithEveryone() {
        List<String> friendsOfJoe = Arrays.asList("Audrey", "Peter", "Michael", "Britney", "Paul");
        Assert.assertTrue(
                friendships.getFriendsList("Joe").containsAll(friendsOfJoe)
        );
    }

}
