//
//  Rozdział 4.
//


//###################################
// str. 148

var p = new Promise( function(resolve,reject){
    // ..
} );

//###################################
// str. 149

function ajax(url,cb) {
    // Generujemy żądane, po czym kiedyś wywołujemy 'cb(..)'
}

// ..

ajax( "http://jakis.url.1", function handler(err,contents){
    if (err) {
        // Obsługujemy błąd żądania AJAX
    }
    else {
        // Obsługujemy zawartość (contents) prawidłowo wykonanego żądania
    }
} );

//-----

function ajax(url) {
    return new Promise( function pr(resolve,reject){
        // Generujemy żądanie, po czym kiedyś wywołujemy
        // albo funkcję 'resolve(..)' albo 'reject(..)'
    } );
}

// ..

ajax( "http://jakis.url.1" )
.then(
    function fulfilled(contents){
        // Obsługujemy zawartość (contents) prawidłowo wykonanego żądania
    },
    function rejected(reason){
        // Obsługujemy błąd (reason) żądania 
    }
);

//###################################
// str. 150

ajax( "http://jakis.url.1" )
    .then(
    function fulfilled(contents){
        return contents.toUpperCase();
    },
    function rejected(reason){
        return "DEFAULT VALUE";
    }
)
.then( function fulfilled(data){
    // Obsługujemy dane zwrócone przez funkcje
    // obsługujące początkową obietnicę
} );

//-----

ajax( "http://jakis.url.1" )
.then(
    function fulfilled(contents){
        return ajax(
            "http://jakis.url.2?v=" + contents
        );
    },
    function rejected(reason){
        return ajax(
            "http://backup.url.3?err=" + reason
        );
    }
)
.then( function fulfilled(contents){
    // 'contents' pochodzi z kolejnego wywołania 'ajax', 
    // niezależnie od tego które z nich zostanie wykonane
} );

//###################################
// str. 151

var th = {
    then: function thener( fulfilled ) {
        // W nieskończoność wywołuje 'fulfilled(..)' co 100ms 
        setInterval( fulfilled, 100 );
    }
};

//###################################
// str. 152

var p1 = Promise.resolve( 42 );

var p2 = new Promise( function pr(resolve){
    resolve( 42 );
} );

//-----

var theP = ajax( .. );

var p1 = Promise.resolve( theP );

var p2 = new Promise( function pr(resolve){
    resolve( theP );
} );

//###################################
// str. 153

var p1 = Promise.reject( "Ups" );

var p2 = new Promise( function pr(resolve,reject){
    reject( "Ups" );
} );


//-----

var p1 = Promise.resolve( 42 );
var p2 = new Promise( function pr(resolve){
    setTimeout( function(){
        resolve( 43 );
    }, 100 );
} );
var v3 = 44;
var p4 = new Promise( function pr(resolve,reject){
    setTimeout( function(){
        reject( "Ups" );
    }, 10 );
} );

//###################################
// str. 154

Promise.all( [p1,p2,v3] )
.then( function fulfilled(vals){
    console.log( vals );            // [42,43,44]
} );

Promise.all( [p1,p2,v3,p4] )
.then(
    function fulfilled(vals){
        // Nigdy tu nie dotrzemy
    },
    function rejected(reason){
        console.log( reason );      // Ups
    }
);

//-----

// UWAGA: wszystkie wartości testowe należy ponownie zdefiniować, 
// by uniknąć ewentualnych problemów związanych z uwarunkowaniami 
// czasowymi, które mogą doprowadzić do błędnych wyników

Promise.race( [p2,p1,v3] )
.then( function fulfilled(val){
    console.log( val );             // 42
} );

Promise.race( [p2,p4] )
.then(
    function fulfilled(val){
        // Nigdy tu nie dotrzemy
    },
    function rejected(reason){
        console.log( reason );      // Ups
    }
);

//###################################
// str. 155

step1()
.then(
    step2,
    step2Failed
)
.then(
    function(msg) {
        return Promise.all( [
            step3a( msg ),
            step3b( msg ),
            step3c( msg )
        ] )
    }
)
.then(step4);

//-----

function *main() {
    var ret = yield step1();
    
    try {
        ret = yield step2( ret );
    }
    catch (err) {
        ret = yield step2Failed( err );
    }

    ret = yield Promise.all( [
        step3a( ret ),
        step3b( ret ),
        step3c( ret )
    ] );

    yield step4( ret );
}


//###################################
// str. 156

function run(gen) {
    var args = [].slice.call( arguments, 1), it;

    it = gen.apply( this, args );
    
    return Promise.resolve()
        .then( function handleNext(value){
            var next = it.next( value );
    
            return (function handleResult(next){
                if (next.done) {
                    return next.value;
                }
                else {
                    return Promise.resolve( next.value )
                        .then(
                            handleNext,
                            function handleErr(err) {
                                return Promise.resolve(
                                it.throw( err )
                                )
                                .then( handleResult );
                            }
                        );
                }
            })( next );
        } );
}

//###################################
// str. 157

run( main )
.then(
    function fulfilled(){
        // Generator '*main()' został pomyślnie wykonany
    },
    function rejected(reason){
        // Ups, coś poszło nie tak
    }
);

//###################################
// str. ??


