//
//  Rozdział 3.
//


//###################################
// str. 89

var arr = [1,2,3];

var it = arr[Symbol.iterator]();

it.next();      // { value: 1, done: false }
it.next();      // { value: 2, done: false }
it.next();      // { value: 3, done: false }

it.next();      // { value: undefined, done: true }


//###################################
// str. 90

var greeting = "witaj, świecie";
var it = greeting[Symbol.iterator]();

it.next();      // { value: "w", done: false }
it.next();      // { value: "i", done: false }
..

//-----

var m = new Map();
m.set( "foo", 42 );
m.set( { cool: true }, "witaj, świecie" );

var it1 = m[Symbol.iterator]();
var it2 = m.entries();

it1.next();     // { value: [ "foo", 42 ], done: false }
it2.next();     // { value: [ "foo", 42 ], done: false }
..

//###################################
// str. 92

var it = {
    // Przekształcamy iterator 'it' w daną iterowalną
    [Symbol.iterator]() { return this; },
    next() { .. },
    ..
};

it[Symbol.iterator]() === it;           // true

//-----

for (var v of it) {
    console.log( v );
}

//-----

for (var v, res; (res = it.next()) && !res.done; ) {
    v = res.value;
    console.log( v );
}

//###################################
// str. 93

var Fib = {
    [Symbol.iterator]() {
        
        var n1 = 1, n2 = 1;
        return {
            // Przekształcamy iterator w daną iterowalną
            [Symbol.iterator]() { return this; },
            
            next() {
                var current = n2;
                n2 = n1;
                n1 = n1 + current;
                return { value: current, done: false };
            },

            return(v) {
                console.log(
                    "Zakończono generację ciągu Fibonacciego."
                );
                return { value: v, done: true };
            }
        };
    }
};
    
for (var v of Fib) {
    console.log( v );
    if (v > 50) break;
}

// 1 1 2 3 5 8 13 21 34 55
// Zakończono generację ciągu Fibonacciego.


//###################################
// str. 94

var tasks = {
    [Symbol.iterator]() {
        var steps = this.actions.slice();

        return {
            // Przekształcamy iterator w daną iterowalną
            [Symbol.iterator]() { return this; },

            next(...args) {
                if (steps.length > 0) {
                    let res = steps.shift()( ...args );
                    return { value: res, done: false };
                }
                else {
                    return { done: true }
                }
            },
    
            return(v) {
                steps.length = 0;
                return { value: v, done: true };
            }
        };
    },
    actions: []
};

//###################################
// str. 95

tasks.actions.push(
    function step1(x){
        console.log( "krok 1.:", x );
        return x * 2;
    },
    function step2(x,y){
        console.log( "krok 2.:", x, y );
        return x + (y * 2);
    },
    function step3(x,y,z){
        console.log( "krok 3.:", x, y, z );
        return (x * y) + z;
    }
);

var it = tasks[Symbol.iterator]();
it.next( 10 );              // krok 1.: 10
                            // { value: 20, done: false }

it.next( 20, 50 );          // krok 2.: 20 50
                            // { value: 120, done: false }

it.next( 20, 50, 120 );     // krok 3.: 20 50 120
                            // { value: 1120, done: false }

it.next();                  // { done: true }

//###################################
// str. 96

if (!Number.prototype[Symbol.iterator]) {
    Object.defineProperty(
        Number.prototype,
        Symbol.iterator,
        {
            writable: true,
            configurable: true,
            enumerable: false,
            value: function iterator(){
                var i, inc, done = false, top = +this;
                
                // Operujemy na liczbach dodatnich czy ujemnych?
                inc = 1 * (top < 0 ? -1 : 1);
                
                return {
                    // Przekształcamy iterator w daną iterowalną
                    [Symbol.iterator](){ return this; },
                    
                    next() {
                        if (!done) {
                            // Pierwszą zwracaną wartością zawsze jest 0
                            if (i == null) {
                                i = 0;
                            }
                            // Iteracja na liczbach dodatnich
                            else if (top >= 0) {
                                i = Math.min(top,i + inc);
                            }
                            
                            // Iteracja na liczbach ujemnych
                            else {
                                i = Math.max(top,i + inc);
                            }
                            
                            // Czy po tej iteracji kończymy?
                            if (i == top) done = true;

                            return { value: i, done: false };
                        }
                        else {
                            return { done: true };
                        }   
                    }
                };
            }
        }
    );
}

//###################################
// str. 97

for (var i of 3) {
    console.log( i );
}
// 0 1 2 3

[...-3];                        // [0,-1,-2,-3]

//-----

var a = [1,2,3,4,5];

//-----

function foo(x,y,z,w,p) {
    console.log( x + y + z + w + p );
}

foo( ...a );                    // 15

//-----

var b = [ 0, ...a, 6 ];
b;                              // [0,1,2,3,4,5,6]

//###################################
// str. 98

var it = a[Symbol.iterator]();

var [x,y] = it;
// Pobieramy tylko dwa pierwsze elementy 'it'
var [z, ...w] = it;
// Teraz pobieramy trzeci element oraz wszystkie pozostałe za jednym razem

// Czy cała zawartość 'it' została już pobrana? Tak.
it.next();              // { value: undefined, done: true }

x;                      // 1
y;                      // 2
z;                      // 3
w;                      // [4,5]

//###################################
// str. 99

function *foo() {
    // ..
}

//-----

function *foo() { .. }
function* foo() { .. }
function * foo() { .. }
function*foo() { .. }
..

//-----

var a = {
    *foo() { .. }
};

//###################################
// str. 100

function *foo(x,y) {
    // ..
}

foo( 5, 10 );

//-----

function *foo() {
    // ..
}

var it = foo();

// Aby rozpocząć lub kontynuować '*foo()', należy 
// użyć wywołania 'it.next(..)'

//-----

function *foo() {
    var x = 10;
    var y = 20;
    
    yield;
    
    var z = x + y;
}

//###################################
// str. 101

function *foo() {
    while (true) {
        yield Math.random();
    }
}

//-----

function *foo() {
    var x = yield 10;
    console.log( x );
}

//-----

function *foo() {
    var arr = [ yield 1, yield 2, yield 3 ];
    console.log( arr, yield 4 );
}

//-----

var a, b;
a = 3;                  // prawidłowe
b = 2 + a = 3;          // nie prawidłowe
b = 2 + (a = 3);        // prawidłowe

yield 3;                // prawidłowe
a = 2 + yield 3;        // nie prawidłowe
a = 2 + (yield 3);      // prawidłowe

//###################################
// str. 102

yield 2 + 3;        // to samo co 'yield (2 + 3)'
(yield 2) + 3;      // najpierw zostanie wykonane 'yield 2', 
                    // a dopiero potem działanie '+ 3'

//###################################
// str. 103

function *foo() {
    yield *[1,2,3];
}

//-----

function *foo() {
    yield 1;
    yield 2;
    yield 3;
}

function *bar() {
    yield *foo();
}

//###################################
// str. 104

function *foo() {
    yield 1;
    yield 2;
    yield 3;
    return 4;
}

function *bar() {
    var x = yield *foo();
    console.log( "x:", x );
}

for (var v of bar()) {
    console.log( v );
}
// 1 2 3
// x: 4

//-----

function *foo(x) {
    if (x < 3) {
        x = yield *foo( x + 1 );
    }
    return x * 2;
}

foo( 1 );

//-----

function *foo(x) {
    if (x < 3) {
        x = yield *foo( x + 1 );
    }
    return x * 2;
}

foo( 1 );

//###################################
// str. 105

function *foo(x) {
    if (x < 3) {
        x = yield *foo( x + 1 );
    }
    return x * 2;
}

var it = foo( 1 );
it.next();                  // { value: 24, done: true }

//-----

function *foo() {
    yield 1;
    yield 2;
    yield 3;
}

//-----

for (var v of foo()) {
    console.log( v );
}
// 1 2 3

//###################################
// str. 106

function *foo() {
    yield 1;
    yield 2;
    yield 3;
}

var it = foo();

it.next();                  // { value: 1, done: false }
it.next();                  // { value: 2, done: false }
it.next();                  // { value: 3, done: false }

it.next();                  // { value: undefined, done: true }

//-----

function *foo() {
    var x = yield 1;
    var y = yield 2;
    var z = yield 3;
    console.log( x, y, z );
}

//###################################
// str. 107

var it = foo();
it.next();                  // { value: 1, done: false }

//-----

it.next( "foo" );           // { value: 2, done: false }
it.next( "bar" );           // { value: 3, done: false }
it.next( "baz" );           // "foo" "bar" "baz"
                            // { value: undefined, done: true }

//###################################
// str. 108

var it = foo();

// Uruchamiamy generator
it.next();                  // { value: 1, done: false }

// Odpowiadamy na pierwsze pytanie
it.next( "foo" );           // { value: 2, done: false }

// Odpowiadamy na drugie pytanie
it.next( "bar" );           // { value: 3, done: false }

// Odpowiadamy na trzecie pytanie
it.next( "baz" );           // "foo" "bar" "baz"
                            // { value: undefined, done: true }

//-----

function *foo() {
    yield 1;
    yield 2;
    yield 3;
}

var it = foo();

it.next();                  // { value: 1, done: false }

it.return( 42 );            // { value: 42, done: true }

it.next();                  // { value: undefined, done: true }

//###################################
// str. 109

function *foo() {
    try {
        yield 1;
        yield 2;
        yield 3;
    }
    finally {
        console.log( "porządki!" );
    }
}

for (var v of foo()) {
    console.log( v );
}
// 1 2 3
// porządki!

var it = foo();

it.next();              // { value: 1, done: false }
it.return( 42 );        // porządki!
                        // { value: 42, done: true }


//###################################
// str. 110

function *foo() {
    yield 1;
    yield 2;
    yield 3;
}

var it1 = foo();
it1.next();             // { value: 1, done: false }
it1.next();             // { value: 2, done: false }

var it2 = foo();
it2.next();             // { value: 1, done: false }

it1.next();             // { value: 3, done: false }

it2.next();             // { value: 2, done: false }
it2.next();             // { value: 3, done: false }

it2.next();             // { value: undefined, done: true }
it1.next();             // { value: undefined, done: true }

//###################################
// str. 111

function *foo() {
    yield 1;
    yield 2;
    yield 3;
}

var it = foo();
it.next();                  // { value: 1, done: false }

try {
    it.throw( "Ups!" );
}
catch (err) {
    console.log( err );     // Wyjątek: Ups!
}

it.next();                  // { value: undefined, done: true }

//-----

function *foo() {
    try {
        yield 1;
    }
    catch (err) {
        console.log( err );
    }

    yield 2;

    throw "Witaj!";
}

var it = foo();

it.next();                  // { value: 1, done: false }

try {
    it.throw( "Cześć!" );   // Cześć!
                            // { value: 2, done: false }
    it.next();
    
    console.log( "Nigdy tu się nie dostaniesz!" );
}
catch (err) {
    console.log( err );     // Witaj!
}


//###################################
// str. 112

function *foo() {
    try {
        yield 1;
    }
    catch (err) {
        console.log( err );
    }

    yield 2;

    throw "foo: e2";
}

function *bar() {
    try {
        yield *foo();

        console.log( "Nigdy tu się nie dostaniesz!" );
    }
    catch (err) {
        console.log( err );
    }
}

var it = bar();

try {
    it.next();              // { value: 1, done: false }

    it.throw( "e1" );       // e1
                            // { value: 2, done: false }
    
    it.next();              // foo: e2
                            // { value: undefined, done: true }
}
catch (err) {
    console.log( "Nigdy tu się nie dostaniesz." );
}

it.next();                  // { value: undefined, done: true }

//###################################
// str. 113

function *foo() {
    var x = yield 42;
    console.log( x );
}

//###################################
// str. 114

function foo() {
    // ..
    
    return {
        next: function(v) {
            // ..
        }
        
        // Pomijamy metody return(..) oraz throw(..)
    };
}

//###################################
// str. 114

function foo() {
    function nextState(v) {
        switch (state) {
            case 0:
                state++;
                
                // Wyrażenie 'yield'
                return 42;
            case 1:
                state++;
                
                // Uzupełnione wyrażenie 'yield' 
                x = v;
                console.log( x );
                
                // Niejawna instrukcja 'return'
                return undefined;

            // Nie musimy obsługiwać stanu '2'
        }
    }   

    var state = 0, x;
    
    return {
        next: function(v) {
            var ret = nextState( v );
            return { value: ret, done: (state == 2) };
        }

        // Pomijamy metody return(..) oraz throw(..)
    };
}

//###################################
// str. 115

var it = foo();

it.next();              // { value: 42, done: false }

it.next( 10 );          // 10
                        // { value: undefined, done: true }

//###################################
// str. 116

function Hello(name) {
    function greeting() {
        console.log( "Witaj, " + name + "!" );
    }

    // publiczny interfejs API
    return {
        greeting: greeting
    };
}

var me = Hello( "Kyle" );
me.greeting();              // Witaj, Kyle!

//###################################
// str. 117

var me = (function Hello(name){
    function greeting() {
        console.log( "Witaj, " + name + "!" );
    }

    // publiczny interfejs API
    return {
        greeting: greeting
    };
})( "Kyle" );

me.greeting();              // Witaj, Kyle!

//###################################
// str. 120

export function foo() {
    // ..
}

export var awesome = 42;

var bar = [1,2,3];
export { bar };

//-----

function foo() {
    // ..
}

var awesome = 42;
var bar = [1,2,3];

export { foo, awesome, bar };

//###################################
// str. 121

function foo() { .. }

export { foo as bar };

//-----

var awesome = 42;
export { awesome };

// nieco później
awesome = 100;

//###################################
// str. 122

function foo(..) {
    // ..
}

export default foo;

//-----

function foo(..) {
    // ..
}

export { foo as default };

//###################################
// str. 123

export default function foo(..) {
    // ..
}

//-----

function foo(..) {
    // ..
}

export { foo as default };

//###################################
// str. 124

export default {
    foo() { .. },
    bar() { .. },
    ..
};

//-----

export default function foo() { .. }

foo.bar = function() { .. };
foo.baz = function() { .. };

//-----

export default function foo() { .. }

export function bar() { .. }
export function baz() { .. }

//###################################
// str. 125

function foo() { .. }
function bar() { .. }
function baz() { .. }

export { foo as default, bar, baz, .. };

//-----

var foo = 42;
export { foo as default };

export var bar = "Witaj, świecie";

foo = 10;
bar = "super";

//###################################
// str. 126

export { foo, bar } from "baz";
export { foo as FOO, bar as BAR } from "baz";
export * from "baz";

//-----

import { foo, bar, baz } from "foo";

//###################################
// str. 127

import { foo } from "foo";

foo();

//-----

import { foo as theFooFunc } from "foo";

theFooFunc();

//-----

import foo from "foo";

// lub:
import { default as foo } from "foo";

//###################################
// str. 128

export default function foo() { .. }

export function bar() { .. }
export function baz() { .. }

//-----

import FOOFN, { bar, baz as BAZ } from "foo";

FOOFN();
bar();
BAZ();

//-----

export function bar() { .. }
export var x = 42;
export function baz() { .. }

//-----

import * as foo from "foo";

foo.bar();
foo.x;                      // 42
foo.baz();

//###################################
// str. 129

export default function foo() { .. }
export function bar() { .. }
export function baz() { .. }

//-----

import foofn, * as hello from "world";

foofn();
hello.default();
hello.bar();
hello.baz();

//-----

import foofn, * as hello from "world";

foofn = 42;                 // (w czasie wykonywania kodu) TypeError!
hello.default = 42;         // (w czasie wykonywania kodu) TypeError!
hello.bar = 42;             // (w czasie wykonywania kodu) TypeError!
hello.baz = 42;             // (w czasie wykonywania kodu) TypeError!

//###################################
// str. 130

foo();

import { foo } from "foo";

//###################################
// str. 131

import bar from "B";

export default function foo(x) {
    if (x > 10) return bar( x - 1 );
    return x * 2;
}

//-----

import foo from "A";

export default function bar(y) {
    if (y > 5) return foo( y / 2 );
    return y * 3;
}

//###################################
// str. 132

import foo from "foo";

foo( 25 );                  // 11

//-----

import bar from "bar";

bar( 25 );                  // 11.5

//###################################
// str. 133

import foo from "foo";
import bar from "bar";

foo( 25 );                  // 11
bar( 25 );                  // 11.5


//###################################
// str. 134

// To fragment normalnego skryptu wyczytanego do 
// przeglądarki przy użyciu znacznika <script>; stosowanie
// instrukcji 'import' w takim kodzie jest niedozwolone.

Reflect.Loader.import( "foo" )  // Zwraca obietnicę '"foo"'
.then( function(foo){
    foo.bar();
} ); 

//###################################
// str. 135

Reflect.Loader.import( "foo", { address: "/path/to/foo.js" } )
.then( function(foo){
    // ..
} )

//###################################
// str. 136

class Foo {
    constructor(a,b) {
        this.x = a;
        this.y = b;
    }

    gimmeXY() {
        return this.x * this.y;
    }
}

//-----

function Foo(a,b) {
    this.x = a;
    this.y = b;
}

Foo.prototype.gimmeXY = function() {
    return this.x * this.y;
}

//-----

var f = new Foo( 5, 15 );

f.x;                    // 5
f.y;                    // 15
f.gimmeXY();            // 75

//###################################
// str. 138

class Bar extends Foo {
    constructor(a,b,c) {
        super( a, b );
        this.z = c;
    }

    gimmeXYZ() {
        return super.gimmeXY() * this.z;
    }
}

var b = new Bar( 5, 15, 25 );

b.x;                    // 5
b.y;                    // 15
b.z;                    // 25
b.gimmeXYZ();           // 1875

//###################################
// str. 139

class ParentA {
    constructor() { this.id = "a"; }
    foo() { console.log( "Klasa ParentA:", this.id ); }
}

class ParentB {
    constructor() { this.id = "b"; }
    foo() { console.log( "Klasa ParentB:", this.id ); }
}

class ChildA extends ParentA {
    foo() {
        super.foo();
        console.log( "Klasa ChildA:", this.id );
    }
}

class ChildB extends ParentB {
    foo() {
        super.foo();
        console.log( "Klasa ChildB:", this.id );
    }
}

var a = new ChildA();
a.foo();                    // Klasa ParentA: a
                            // Klasa ChildA: a
var b = new ChildB();       // Klasa ParentB: b
b.foo();                    // Klasa ChildB: b

//-----

// pożyczamy 'b.foo()', by użyć jej w kontekście 'a'
b.foo.call( a );            // Klasa ParentB: a
                            // Klasa ChildB: a

//###################################
// str. 141

constructor(...args) {
    super(...args);
}

//-----

function Foo() {
    this.a = 1;
}

function Bar() {
    this.b = 2;
    Foo.call( this );
}

// Bar "rozszerza" Foo
Bar.prototype = Object.create( Foo.prototype );

//###################################
// str. 142

class Foo {
    constructor() { this.a = 1; }
}

class Bar extends Foo {
    constructor() {
        this.b = 2;     // nie dozwolone przed wywołaniem super()
        super();        // by poprawić kod należy zamienić kolejność tych dwóch wierszy
    }
}

//-----

class MyCoolArray extends Array {
    first() { return this[0]; }
    last() { return this[this.length - 1]; }
}

var a = new MyCoolArray( 1, 2, 3 );

a.length;               // 3
a;                      // [1,2,3]

a.first();              // 1
a.last();               // 3

//###################################
// str. 143

class Oops extends Error {
    constructor(reason) {
        this.oops = reason;
    }
}

// i dalej:
var ouch = new Oops( "Coś namieszałem!" );
throw ouch;

//-----

class Foo {
    constructor() {
        console.log( "Foo: ", new.target.name );
    }
}

class Bar extends Foo {
    constructor() {
        super();
        console.log( "Bar: ", new.target.name );
    }

    baz() {
        console.log( "baz: ", new.target );
    }
}

var a = new Foo();
// Foo: Foo

var b = new Bar();
// Foo: Bar <-- uwzględnia fukcję konstuktra używą w operatorze new
// Bar: Bar

b.baz();
// baz: undefined

//###################################
// str. 144

class Foo {
    static cool() { console.log( "super" ); }
    wow() { console.log( "wow" ); }
}

class Bar extends Foo {
    static awesome() {
        super.cool();
        console.log( "niesamowite" );
    }
    neat() {
        super.wow();
        console.log( "fajne" );
    }
}

Foo.cool();                 // "super"

Bar.cool();                 // "super"
Bar.awesome();              // "super"
                            // "niesamowite"

var b = new Bar();
b.neat();                   // "wow"
                            // "fajne"

b.awesome;                  // undefined
b.cool;                     // undefined


//-----

class MyCoolArray extends Array {
    // Wymuszamy, by 'species' wskazywała konstruktor klasy bazowej
    static get [Symbol.species]() { return Array; }
}

var a = new MyCoolArray( 1, 2, 3 ),
    b = a.map( function(v){ return v * 2; } );

b instanceof MyCoolArray;       // false
b instanceof Array;             // true

//-----

class Foo {
    // Przenosimy 'species' do konstruktora klasy pochodnej
    static get [Symbol.species]() { return this; }
    spawn() {
        return new this.constructor[Symbol.species]();
    }
}

class Bar extends Foo {
    // Wymuszamy, by 'species' wskazywała konstruktor klasy bazowej
    static get [Symbol.species]() { return Foo; }
}

var a = new Foo();
var b = a.spawn();
b instanceof Foo;               // true

var x = new Bar();
var y = x.spawn();
y instanceof Bar;               // false
y instanceof Foo;               // true



