const nodemailer = require('nodemailer')

const credentials = require('./credentials')

const mailTransport = nodemailer.createTransport({
  host: 'smtp.sendgrid.net',
  auth: {
    user: credentials.sendgrid.user,
    pass: credentials.sendgrid.password,
  },
})

async function go() {
  try {
    const result = await mailTransport.sendMail({
      from: '"Meadowlark Travel" <info@meadowlarktravel.com>',
      to: 'joecustomer@gmail.com',
      subject: 'Twoja wycieczka z Meadowlark Travel',
      text: 'Dziękujemy za rezerwację wycieczki w biurze Meadowlark Travel.  ' +
        'Czekamy na Twoją wizytę!',
    })
    console.log('poczta wysłana z powodzeniem: ', result)
  } catch(err) {
    console.log('nie udało się wysłać poczty: ' + err.message)
  }
}

go()
