# Przykłady z rozdziału  6. - Tworzenie aplikacji internetowych z użyciem Node i Express, Wydanie II

### Konfiguracja

Przykład z tego rozdziału zawiera zależności od modułów Node (`express` i `express-handlebars`).  Te zależności są uwzględnione w pliku _package.json_.  Jednak po pobraniu tego kodu nie będą zainstalowane (_package.json_ jest tylko plikiem manifestu).  Aby je zainstalować, należy wykonać poniższe polecenie:

```
npm install
```

### Wyświetlanie treści nagłówków

Ten przykład demonstruje odczytywanie przez Express nagłówków wysłanych przez klienta (przeglądarkę), a następnie ich wyświetlanie. Uruchamianie:

```
node 00-echo-headers
```

### Wyłączanie nagłówka "Powered By Express"

Ten przykład prezentuje wyłączanie nagłówka odpowiedzi `X-Powered-By` (zwykle ze względów bezpieczeństwa). Uruchamianie:

```
node 01-disabled-x-powered-by
```

### Podstawowe renderowanie

Ten przykład prezentuje podstawowe renderowanie z użyciem silnika szablonów (w tym przypadku Handlebars). Uruchamianie:

```
node 02-basic-rendering
```

### Kody odpowiedzi inne niż 200

Ten przykład prezentuje wysyłanie kodów odpowiedzi innych niż 200. Uruchamianie:

```
node 03-different-response-codes
```

### Renederowanie widoku bez kontekstu

This example demonstrates how request handlers can pass context to a view for dynamic content.  This example demonstrates passing context data directly, from the querystring, from cookies, and from sessions.  To run:

```
node 04-view-with-content`
```

### View Without Layout

This example demonstrates rendering a page without using a template (giving the view full control over what's sent to the client).  To run:

```
node 05-view-without-layout
```

### View With Custom Layout

This example demonstrates using a custom layout.  To run:

```
node 06-custom-layout
```

### View With Plain Text Layout

This example demonstrates a response with a plain text (not HTML) response, bypassing the view system.  To run:

```
node 07-plaintext-output
```

### Error Handler

This example demonstrates the Express error handling mechanism.  To run:

```
node 08-error-handler
```

### Custom 404 Handler

This example demonstrates how to use a custom 404 (Not Found) handler.  To run:

```
node 09-custom-404
```

### Basic Form Procerssing

This example demonstrates basic form processing.  To run:

```
node 10-basic-form-processing
```

### More Robust Form Processing

This example demonstrates more robust form processing, demonstrating how you might handle persistence (database) failure, as well as using the [Fetch API](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API).  To run:

```
node 11-more-robust-form-processing
```

### HTTP GET API Example

This example demonstrates a basic HTTP GET API response.  To run:

```
node 12-api-get
```

### HTTP GET API Example - Multiple Encodings

This example demonstrates an HTTP GET API response that respects the `Accept` header to respond in JSON, XML, or plain text.  To run:

```
node 13-api-json-xml-text
```

Note that you will have to use something like [Postman](https://www.getpostman.com/) or [curl](https://curl.haxx.se/) to get responses in different encodings.  If you use a browser, you will typically get the response in XML since `application/xml` appears in the `Accept` header in most browsers.

### HTTP PUT API Example

This example adds an HTTP PUT endpoint (in addition to the GET endpoint) that allows for modification of the data.  The data is stored in memory, and will be reset when the application is re-started (i.e. there is no persistence).  To run:

```
node 14-api-put
```

Note that you will have to use something like [Postman](https://www.getpostman.com/) or [curl](https://curl.haxx.se/) to try this example.

### HTTP DELETE API Example

This example adds an HTTP DELETE endpoint (in addition to the GET endpoint) that allows for deletion of the data.  The data is stored in memory, and will be reset when the application is re-started (i.e. there is no persistence).  To run:

```
node 15-api-del
```

Note that you will have to use something like [Postman](https://www.getpostman.com/) or [curl](https://curl.haxx.se/) to try this example.
