const express = require('express')
const expressHandlebars = require('express-handlebars')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// treść znajduje się w pliku views/custom-layout.hbs, natomiast
// układ znajduje się w pliku views/layouts/custom.hbs
app.get('/custom-layout', (req, res) =>
  res.render('custom-layout', { layout: 'custom' })
)

app.get('*', (req, res) => res.send('Sprawdź stronę z "<a href="/custom-layout">niestandardowym układem</a>"!'))

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}/custom-layout\n`))
