const express = require('express')
const expressHandlebars = require('express-handlebars')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// plik views/about.hbs zawiera kod tego widoku
app.get('/about', (req, res) => {
  res.render('about')
})

app.get('*', (req, res) => res.send('Sprawdź naszą stronę "<a href="/about">O nas</a>"!'))

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}/about\n`))
