module.exports = {

  resetValidation(req, res, next) {
    const { cart } = req.session
    if(cart) {
      cart.warnings = []
      cart.errors = []
    }
    next()
  },

  checkWaivers(req, res, next) {
    const { cart } = req.session
    if(!cart) return next()
    if(cart.items.some(item => item.product.requiresWaiver)) {
      cart.warnings.push('Co najmniej jedna z wybranych ' +
        'wycieczek wymaga oświadczenia o zrzeczeniu się odpowiedzialności.')
    }
    next()
  },

  checkGuestCounts(req, res, next) {
    const { cart } = req.session
    if(!cart) return next()
    if(cart.items.some(item => item.guests > item.product.maxGuests )) {
      cart.errors.push('Co najmniej jedna z wybranych wycieczek ' +
        'nie ma wystarczającej liczby wolnych miejsc, aby przyjąć wybraną ' +
        'liczbę gości.')
    }
    next()
  },

}
