<?php

// pogawędka z użyciem gniazd

require __DIR__
    . DIRECTORY_SEPARATOR
    .'..'
    . DIRECTORY_SEPARATOR
    . 'vendor'
    . DIRECTORY_SEPARATOR
    .'autoload.php';

$loop = React\EventLoop\Factory::create();
$socket = new React\Socket\Server($loop);

$conns = new \SplObjectStorage();

$socket->on('connection', function ($conn) use ($conns) {
    $conns->attach($conn);

    $conn->on('data', function ($data) use ($conns, $conn) {
        foreach ($conns as $current) {

            if ($conn === $current) {
                continue;
            }

            $current->write($conn->getRemoteAddress().': ');
            $current->write($data);
        }

    });

    $conn->on('end', function () use ($conns, $conn) {
        $conns->detach($conn);
    });
});

echo "Serwer gniazd nasłuchuje na porcie 4000.\n";
echo "Aby się z nim połączyć, wydaj polecenie: telnet localhost 4000\n";

$socket->listen(4000);
$loop->run();
