C#include <coroutine>
#include <iostream>
#include <thread>

template <typename T>
struct generator {
  struct Promise;

// kompilator szuka promise_type
  using promise_type=Promise;
  std::coroutine_handle<Promise> h_;

  generator(std::coroutine_handle<Promise> h): h_(h) {}

  ~generator() {
    if (h_) h_.destroy();
  }

// uzyskanie bieżącej wartości współprogramu
  int value() {
    return h_.promise().val;
  }

// dalsze działanie współprogramu po wstrzymaniu
  bool next() {
    h_.resume();
    return !h_.done();
  }

  struct Promise {
// bieżąca wartość wstrzymanego współprogramu
    T val;

// wywoływane najpierw przez kompilator w celu uzyskania wyniku współprogramu
    generator get_return_object() {
      return generator{std::coroutine_handle<Promise>::from_promise(*this)};
    }

// wywoływane przez kompilator przy pierwszym wystąpieniu operatora co_yield
    std::suspend_always initial_suspend() {
      return {};
    }

// wymagane dla operatora co_yield
    std::suspend_always yield_value(T x) {
      val=x;
      return {};
    }

// wywoływane przez kompilator dla współprogramu bez zwracanego wyniku
    std::suspend_never return_void() {
      return {};
    }

void unhandled_exception() {}

// wywoływane na koniec przez kompilator w celu oczekiwania na końcowy wynik
// współprogram nie może zostać wznowiony po wywołaniu tego
    std::suspend_always final_suspend() noexcept {
      return {};
    }
  };

};

generator<int> coro(int n) {

  for(int i = 0; i < n; ++i) {
    co_yield i;
  }

}

int main ()
{
  int n=10;

  generator gen = coro(n);

  for(int i=0; i < n; ++i) {
    gen.next();
    printf("%d ", gen.value());
  }

  return 0;
}
