#include <coroutine>
#include <iostream>
#include <thread>

struct awaitable {
    std::jthread& t3;
    bool await_ready() { return false; }
    void await_suspend(std::coroutine_handle<> h) {
        std::jthread& out = t3;
        out = std::jthread([h] { h.resume(); });
        std::cout << "Identyfikator nowego wątku: " << out.get_id() << '\n';
    }
    void await_resume() {}
    ~awaitable() {
        std::cout << "Usunięto obiekt oczekujący: " << std::this_thread::get_id() << " z wątkiem " << t3.get_id() << '\n';
    }
    awaitable(std::jthread& t) : t3(t) {
        std::cout << "Utworzono w wątku obiekt oczekujący: " << std::this_thread::get_id() << '\n';
    }
};

struct task{
    struct promise_type {
        task get_return_object() { return {}; }
        std::suspend_never initial_suspend() { return {}; }
        std::suspend_never final_suspend() noexcept { return {}; }
        void return_void() {}
        void unhandled_exception() {}
    };
};

task coro(std::jthread& t1, std::jthread& t2, int i) {
    std::cout << "Uruchomiono współprogram w wątku: " << std::this_thread::get_id() << " i=" << i << '\n';
    co_await awaitable{t1};
    std::cout << "Wznowiono współprogram w wątku: " << std::this_thread::get_id() << " i=" << i << '\n';
    
    #if 0
    std::cout << "Współprogram kontynuuje działanie w wątku: " << std::this_thread::get_id() << " i=" << i << '\n';    
    co_await awaitable{t2};
    // w tym miejscu jest usuwany obiekt oczekujący
    std::cout << "Wznowiono współprogram w wątku: " << std::this_thread::get_id() << " i=" << i << '\n';
    #endif
    std::cout << "Współprogram zakończył działanie w wątku: " << std::this_thread::get_id() << " i=" << i << '\n';
}

int main() {
    std::cout << "Główny wątek: " << std::this_thread::get_id() << '\n';
    {
        std::jthread t1, t2;
        coro(t1, t2, 42);
        std::cout << "Zakończono główny wątek: " << std::this_thread::get_id() << std::endl;
    }
    std::cout << "Faktycznie zakończono główny wątek: " << std::this_thread::get_id() << std::endl;
}
