import tensorflow as tf
from tensorflow import keras
from tensorflow.keras.preprocessing.text import Tokenizer

sentences = [
    'Dzisiaj mamy soneczny dzie', 
    'Dzisiaj mamy deszczowy dzie'  
]

tokenizer = Tokenizer(num_words = 100)
tokenizer.fit_on_texts(sentences)
word_index = tokenizer.word_index
print(word_index)



sentences = [
    'Dzisiaj mamy soneczny dzie', 
    'Dzisiaj mamy deszczowy dzie',  
    'Czy dzisiaj mamy soneczny dzie?'
]

tokenizer = Tokenizer(num_words = 100)
tokenizer.fit_on_texts(sentences)
word_index = tokenizer.word_index
print(word_index)



sentences = [
    'Dzisiaj mamy soneczny dzie', 
    'Dzisiaj mamy deszczowy dzie',  
    'Czy dzisiaj mamy soneczny dzie?'
]

tokenizer = Tokenizer(num_words = 100)
tokenizer.fit_on_texts(sentences)
word_index = tokenizer.word_index

sequences = tokenizer.texts_to_sequences(sentences)
print(sequences)



test_data = [
    'Dzisiaj pada nieg',
    'Czy jutro bdzie deszczowy dzie?'
]

test_sequences = tokenizer.texts_to_sequences(test_data)
print(word_index)
print(test_sequences)



tokenizer = Tokenizer(num_words = 100, oov_token="<OOV>")
tokenizer.fit_on_texts(sentences)
word_index = tokenizer.word_index
sequences = tokenizer.texts_to_sequences(sentences)

test_sequences = tokenizer.texts_to_sequences(test_data)
print(word_index)
print(test_sequences)



sentences = [
    'Dzisiaj mamy soneczny dzie', 
    'Dzisiaj mamy deszczowy dzie',  
    'Czy dzisiaj mamy soneczny dzie?',
    'Bardzo podoba mi si dzisiejszy spacer po niegu'
]

tokenizer = Tokenizer(num_words = 100)
tokenizer.fit_on_texts(sentences)
word_index = tokenizer.word_index

sequences = tokenizer.texts_to_sequences(sentences)
print(sequences)



from tensorflow.keras.preprocessing.sequence import pad_sequences

padded = pad_sequences(sequences)
print(padded)



padded = pad_sequences(sequences, padding='post')
print(padded)



padded = pad_sequences(sequences, padding='post', maxlen=6)
print(padded)



padded = pad_sequences(sequences, padding='post', maxlen=6, truncating='post')
print(padded)