# Uwaga
# W przypadku problemów z wykonaniem skryptu w Pycharm spróbuj wyczyścić cache,
# co może rozwiązać problemy z autouzupełnianiem. W tym celu przejdź do
# File > Invalidate Caches / Restart, wybierz Invalidate and Restart.
# Jeśli to nie zadziała, to uruchom skrypt z poziomu linii poleceń

import pandas as pd
import matplotlib.pyplot as plt
from sklearn.preprocessing import StandardScaler
df = pd.read_excel('outliers.xlsx', header=0)
scaler = StandardScaler()
scaled_df = pd.DataFrame(scaler.fit_transform(df), columns=df.columns)

fig, axes = plt.subplots(nrows=1, ncols=2)

# Wykres skrzypcowy
axes[0].violinplot(scaled_df.values, vert=True)
axes[0].set_ylabel('Wartości (po standaryzacji)')
axes[0].set_title('Wykres skrzypcowy')
axes[0].set_xticks(range(1, len(df.columns) + 1))
axes[0].set_xticklabels(df.columns)
# Wykres pudełkowy
axes[1].boxplot(scaled_df.values)
axes[1].set_ylabel('Wartości (po standaryzacji)')
axes[1].set_title('Wykres pudełkowy')
axes[1].set_xticks(range(1, len(df.columns) + 1))
axes[1].set_xticklabels(df.columns)

plt.tight_layout()
plt.show()
