import numpy as np
from scipy import stats
import matplotlib.pyplot as plt

X1 = np.array([10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0])
Y1 = np.array([8.04, 6.95, 7.58, 8.81, 8.33, 9.96, 7.24, 4.26, 10.84, 4.82, 5.68])
X2 = np.array([10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0])
Y2 = np.array([9.14, 8.14, 8.74, 8.77, 9.26, 8.10, 6.13, 3.10, 9.13, 7.26, 4.74])
X3 = np.array([10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0])
Y3 = np.array([7.46, 6.77, 12.74, 7.11, 7.81, 8.84, 6.08, 5.39, 8.15, 6.42, 5.73])
X4 = np.array([8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 19.0, 8.0, 8.0, 8.0])
Y4 = np.array([6.58, 5.76, 7.71, 8.84, 8.47, 7.04, 5.25, 12.50, 5.56, 7.91, 6.89])

B1, A1, _, _, _ = stats.linregress(X1, Y1)
B2, A2, _, _, _ = stats.linregress(X2, Y2)
B3, A3, _, _, _ = stats.linregress(X3, Y3)
B4, A4, _, _, _ = stats.linregress(X4, Y4)

fig, axs = plt.subplots(2, 2)

axs[0, 0].scatter(X1, Y1, color='green')
axs[0, 0].plot(X1, A1 + B1 * X1, '-k', label='Y1 = {:.2f} + {:.2f}*X1'.format(A1, B1))
axs[0, 0].set_title('Kwartet Anscombe’a 1.')
axs[0, 0].set_xlabel('X1')
axs[0, 0].set_ylabel('Y1')

axs[0, 1].scatter(X2, Y2, color='red')
axs[0, 1].plot(X2, A2 + B2 * X2, '-k', label='Y2 = {:.2f} + {:.2f}*X2'.format(A2, B2))
axs[0, 1].set_title('Kwartet Anscombe’a 2.')
axs[0, 1].set_xlabel('X2')
axs[0, 1].set_ylabel('Y2')

axs[1, 0].scatter(X3, Y3, color='brown')
axs[1, 0].plot(X3, A3 + B3 * X3, '-k', label='Y3 = {:.2f} + {:.2f}*X3'.format(A3, B3))
axs[1, 0].set_title('Kwartet Anscombe’a 3.')
axs[1, 0].set_xlabel('X3')
axs[1, 0].set_ylabel('Y3')

axs[1, 1].scatter(X4, Y4, color='orange')
axs[1, 1].plot(X4, A4 + B4 * X4, '-k', label='Y4 = {:.2f} + {:.2f}*X4'.format(A4, B4))
axs[1, 1].set_title('Kwartet Anscombe’a 4.')
axs[1, 1].set_xlabel('X4')
axs[1, 1].set_ylabel('Y4')

plt.tight_layout()
plt.show()
